/*
* @name jQuery.bootcomplete
* @projectDescription Lightweight AJAX autocomplete for Bootstrap 3
* @author Rick Somers | http://getwebhelp.com/bootcomplete
* @version 1.0
* @license MIT License
* 
* Rev 25.8.2016 [ABS] - The Javascript Library had to be modified to suit how a practical 
*	application works. The usage of the control, AFTER we have changed it, requires that
*	a hidden field be added in the page to recieve the ID [subcd,itemcd,etc.]
*/
(function ( $ ) {
 
    $.fn.bootcomplete = function(options) {
        
        var defaults = {
            url : "/search.php",
            method : 'get',
            wrapperClass : "bc-wrapper",
            menuClass : "bc-menu",
            idField : true,
            idFieldName : $(this).attr('name')+"_id",
            minLength : 3,
            dataParams : {},
            formParams : {}
        }
        
        var settings = $.extend( {}, defaults, options );
        
        $(this).attr('autocomplete','off')
        $(this).wrap('<div class="'+settings.wrapperClass+'"></div>')
        if(settings.idField){
			// Rev 25.8.2016 [ABS] - Unlike the default behaviour, which adds a hidden field each
			// time this control is invoked, we make thr programmer add a hidden control to recieve
			// the selected ID. This is because, once a selection is made, and for any reason a submit
			// is made and the same page is re-rendered, the selected ID is lost as the page rendering
			// mechanism does not know about the control. We may want the selected ID back post-submit.
            //$('<input type="hidden" name="'+settings.idFieldName+'" value="">').insertBefore($(this))
        }
        $('<div class="'+settings.menuClass+' list-group"></div>').insertAfter($(this))
        
        $(this).on( "keyup", searchQuery );
        
        var xhr;
        var that =  $(this)
        
        function searchQuery(){
            
            var arr = [];
            $.each(settings.formParams,function(k,v){
                arr[k]=$(v).val()
            })
            var dyFormParams = $.extend({}, arr );
            var Data = $.extend({query: $(this).val()}, settings.dataParams, dyFormParams);
            
            if(!Data.query){
                $(this).next('.'+settings.menuClass).html('')    
                $(this).next('.'+settings.menuClass).hide()    
            }
            
            if(Data.query.length >= settings.minLength){
                
                if(xhr && xhr.readyState != 4){
                    xhr.abort();
                }
                
                xhr = $.ajax({
                    type: settings.method,
                    url: settings.url,
                    data: Data,
                    dataType: "json",
                    success: function( json ) {
                        var results = ''
                        $.each( json, function(i, j) {
                            results += '<a href="#" class="list-group-item" data-id="'+j.id+'" data-label="'+j.label+'">'+j.label+'</a>'
                        });
                        
                        $(that).next('.'+settings.menuClass).html(results)
                        $(that).next('.'+settings.menuClass).children().on("click", selectResult)
                        $(that).next('.'+settings.menuClass).show()
                   
                    }
                })
            }
        }
        
        function selectResult(){
            $(that).val($(this).data('label'))
            if(settings.idField){
				// Rev 25.8.2016 [ABS] - Since the programmer adds a hidden field manually on the page, 
				// we should update the value of THAT control and not try to search for PREV,etc.
                //$(that).prev('input[name="'+settings.idFieldName+'"]').val($(this).data('id'));
				$('input[name="'+settings.idFieldName+'"]').val($(this).data('id'));
            }
            $(that).next('.' + settings.menuClass).hide();
            // Rev 25.8.2016 [ABS] - When a user makes a selection, we should hit the onblur event of the
            // textbox automatically. This was not the default behaviour.
            $(that).trigger("onblur");
            return false;
        }

        return this;
    };
 
}( jQuery ));
