﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ChequeEntryAddEdit.aspx.cs" Inherits="Connect_DotNet.ChequeEntryAddEdit" %>
<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<!DOCTYPE html>

<html>
<head runat="server">
    <title></title>

    <!--
	<link rel="stylesheet" type="text/css" media="screen" href="../css/bootstrap.min.css">
        -->

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
	<!-- Optional theme -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap-theme.min.css" integrity="sha384-rHyoN1iRsVXV4nD0JutlnGaslCJuC7uwjduW9SVrLvRYooPp2bWYgmgJQIXwl/Sp" crossorigin="anonymous">

	<link href="../css/font-awesome.min.css" rel="stylesheet" />

	<%--SmartAdmin Styles : Caution! DO NOT change the order 
	<link rel="stylesheet" type="text/css" media="screen" href="../css/smartadmin-production-plugins.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../css/smartadmin-production.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../css/smartadmin-skins.min.css"> --%>
	
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">

	<link href="../css/your_style.css" rel="stylesheet" />
    <link href="../css/font-awesome-animation.min.css" rel="stylesheet" />

	<style>
		#tblInput { border:none }
		#tblInput td, #tblInput th { border:none;vertical-align:middle;padding:2px !important }

		.completionList {overflow-y:auto;background-color:white;border:1px solid silver;margin:0;padding:3px }
		.listItem { color:black;padding:3px }
		.itemHighlighted { background-color:lightyellow;padding:3px }
	</style>
</head>
<body style="overflow:hidden">
       <script type="text/javascript">  
           function OnTextChangedHandler(s) {
               var inputtext = s.GetText();
               var isChequeNo = new RegExp("\\d{6}").test(inputtext);
               if (inputtext != 'NEFT' && inputtext != 'RTGS' && isChequeNo != true) {
                   alert(inputtext+": Enter a valid 6 digit Cheque Number or one the following Values NEFT,RTGS!")
                   s.SetText('');
               }

               
            
        }  
     </script>  

	<div class="container-fluid">
		<div class="row">
			<div class="col-sm-7">
				<br />
				<form id="frmChequeEntries" runat="server">
					<asp:ScriptManager ID=ScriptManager1 runat="server" EnablePageMethods="true" EnablePartialRendering="true"></asp:ScriptManager>
					<table id="tblInput" class="table table-condensed table-responsive">
						<colgroup>
							<col style="width:20%"/><col style="width:40%"/>
							<col style="width:20%"/><col style="width:20%"/>
						</colgroup>
						<tr>
							<td style="text-align:right">Segment :</td>
							<td>
                                <dx:ASPxComboBox ID=cboSegment ClientInstanceName="cboSegment" runat="server" NullText="Mandatory . . ." AutoPostBack="true" 
									CssClass="form-control input-sm" OnSelectedIndexChanged="cboSegment_SelectedIndexChanged">
									<ClientSideEvents SelectedIndexChanged="function(s,e){ cboSegment_SelectedIndexChanged(); }" />
								</dx:ASPxComboBox>
								
							</td>
							<td></td>
							<td></td>
						</tr>
						<tr>
							<td style="text-align:right">Receiving Account :</td>
							<td>
								<asp:UpdatePanel ID=UpdatePanel1 runat="server">
									<ContentTemplate>
										<dx:ASPxComboBox ID=cboRecvBank ClientInstanceName="cboRecvBank" runat="server" NullText="Mandatory . . ." CssClass="form-control input-sm">
											<ClientSideEvents SelectedIndexChanged="function(s,e){ cboRecvBank_SelectedIndexChanged(); }" />
										</dx:ASPxComboBox>
									</ContentTemplate>
									<Triggers>
										<asp:AsyncPostBackTrigger ControlID="cboSegment" EventName="SelectedIndexChanged" />
									</Triggers>
								</asp:UpdatePanel>
							</td>
							<td colspan="2">
								<asp:UpdatePanel ID=UpdatePanel2 runat="server">
									<ContentTemplate>
										<dx:ASPxTextBox ID=txtRecvAcc ClientInstanceName="txtRecvAcc" runat="server" 
											CssClass="form-control input-sm" ReadOnly="true">
										</dx:ASPxTextBox>
									</ContentTemplate>
									<Triggers>
										<asp:AsyncPostBackTrigger ControlID="cboSegment" EventName="SelectedIndexChanged" />
									</Triggers>
								</asp:UpdatePanel>
							</td>
						</tr>
						<tr>
							<td style="text-align:right">Client :</td>
							<td colspan="3">
								<ajaxToolkit:AutoCompleteExtender ID=AutoCompleteExtender1 runat="server" 
									CompletionListCssClass="completionList"
									CompletionListItemCssClass="listItem"
									CompletionListHighlightedItemCssClass="itemHighlighted"
									ServiceMethod="GetCompletionList"
									MinimumPrefixLength="1"    
									CompletionInterval="10" 
									EnableCaching="false"
									TargetControlID="txtClient"    
									FirstRowSelected="false" 
									OnClientItemSelected="SelectedItem">   
								</ajaxToolkit:AutoCompleteExtender>
								<asp:HiddenField ID=hdnSubCd runat="server" />
								<asp:TextBox ID=txtClient runat="server" CssClass="form-control input-sm" AutoPostBack="true" 
									OnTextChanged="txtClient_TextChanged">
								</asp:TextBox>
							</td>
						</tr>
						<tr>
							<td style="text-align:right">Client Account No. :</td>
							<td>
								<asp:UpdatePanel ID=UpdatePanel3 runat="server">
									<ContentTemplate>
										<dx:ASPxComboBox ID=cboAccNo ClientInstanceName="cboAccNo" runat="server" NullText="Mandatory . . ." CssClass="form-control input-sm">
											<ClientSideEvents SelectedIndexChanged="function(s,e){ cboAccNo_SelectedIndexChanged(); }" />
										</dx:ASPxComboBox>
										<dx:ASPxTextBox ID=txtAccNo ClientInstanceName="txtAccNo" runat="server" 
											NullText="Mandatory . . ." CssClass="form-control input-sm"
											OnTextChanged="txtAccNo_TextChanged" AutoPostBack="true">
										</dx:ASPxTextBox>
										<asp:HiddenField ID=hdnBankCd runat="server" />
									</ContentTemplate>
									<Triggers>
										<asp:AsyncPostBackTrigger ControlID="txtClient" EventName="TextChanged" />
									</Triggers>
								</asp:UpdatePanel>
							</td>
							<td colspan="2">
								<asp:UpdatePanel ID=UpdatePanel4 runat="server">
									<ContentTemplate>
										<dx:ASPxTextBox ID=txtBank ClientInstanceName="txtBank" runat="server" CssClass="form-control input-sm" ReadOnly="true"></dx:ASPxTextBox>
									</ContentTemplate>
									<Triggers>
										<asp:AsyncPostBackTrigger ControlID="txtClient" EventName="TextChanged" />
										<asp:AsyncPostBackTrigger ControlID="txtAccNo" EventName="TextChanged" />
									</Triggers>
								</asp:UpdatePanel>
							</td>
						</tr>
						<tr>
							<td style="text-align:right">Amount : Rs.</td>
							<td>
								<dx:ASPxTextBox ID=txtAmount ClientInstanceName="txtAmount" runat="server" NullText="Mandatory . . ." 
									CssClass="form-control input-sm" HorizontalAlign="Right">
									<MaskSettings Mask="<0..999999999g>.<00..99>" IncludeLiterals="DecimalSymbol" />
								</dx:ASPxTextBox>
							</td>
							<td></td>
							<td></td>
						</tr>
						<tr>
							<td style="text-align:right;vertical-align:top">Cheque No. :</td>
							<td>
								<dx:ASPxTextBox ID=txtChequeNo ClientInstanceName="txtChequeNo" runat="server" NullText="Mandatory . . ." CssClass="form-control input-sm">
									  <ClientSideEvents  
                                    TextChanged="function(s, e) {  
                                        OnTextChangedHandler(s);  
                                    }" />  
								</dx:ASPxTextBox>
                                
                                <span style="color:grey; font-size:8pt">Accepts valid Cheque Number or "NEFT" or "RTGS"</span>
							</td>
							<td style="text-align:left;vertical-align:top" colspan="2">
								<dx:ASPxTextBox ID=txtReference ClientInstanceName="txtReference" runat="server" NullText="Bank Reference . . ." CssClass="form-control input-sm">
								</dx:ASPxTextBox>
                                <span style="color:grey; font-size:8pt">Bank Reference</span>
							</td>
						</tr>
						<tr>
							<td style="text-align:right">Cheque Date :</td>
							<td>
								<dx:ASPxDateEdit ID=dtCheque ClientInstanceName="dtCheque" runat="server" NullText="Mandatory . . ." CssClass="form-control input-sm" 
									UseMaskBehavior="true" EditFormatString="dd/MM/yyyy">
								</dx:ASPxDateEdit>
							</td>
							<td></td>
							<td></td>
						</tr>
						<tr>
							<td style="text-align:right;vertical-align:top">Narration :</td>
							<td colspan="3">
								<dx:ASPxMemo ID=txtNarration ClientInstanceName="txtNarration" NullText="Mandatory . . ." runat="server" Height="100px" CssClass="form-control input-sm"></dx:ASPxMemo>
							</td>
						</tr>
						<tr>
							<td style="text-align:right;vertical-align:top">Scanned Image :</td>
							<td colspan="2">
								<asp:UpdatePanel ID=UpdatePanel5 runat="server">
									<ContentTemplate>
										<asp:FileUpload ID=uldChequeImage AllowMultiple="false" runat="server" CssClass="form-control input-sm" />
										<asp:HiddenField ID=hdnFileName runat="server" />
										<dx:ASPxLabel ID=lblUploadStatus runat="server"></dx:ASPxLabel>
									</ContentTemplate>
									<Triggers>
										<asp:PostBackTrigger ControlID="btnUpload" />
									</Triggers>
								</asp:UpdatePanel>	
							</td>
							<td style="vertical-align:top">
								<dx:ASPxButton ID=btnUpload Text="Upload" runat="server" OnClick="btnUpload_Click" 
									CssClass="btn btn-success btn-sm">
									<ClientSideEvents Click="function(s,e) { e.processOnServer = btnUpload_click(s,e); }" />
								</dx:ASPxButton>
							</td>
						</tr>
						<%--																							
						<tr>
							<td colspan="3" style="text-align:right">
								<dx:ASPxButton ID=btnSave Text="Save" runat="server" OnClick="btnSave_Click" CssClass="btn btn-primary">
								</dx:ASPxButton>
							</td>
						</tr>
						--%>
					</table>		
				</form>
			</div>
		</div>
	</div>

    <!--
	<script src="../js/libs/jquery-2.1.1.min.js"></script>
	<script src="../js/bootstrap/bootstrap.min.js"></script>
        -->

    <script  src="https://code.jquery.com/jquery-3.7.1.min.js"  integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo="  crossorigin="anonymous"></script>
    <script  src="https://code.jquery.com/ui/1.14.0/jquery-ui.min.js"  integrity="sha256-Fb0zP4jE3JHqu+IBB9YktLcSjI1Zc6J2b6gTjB0LpoM="  crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>


	<link href="../scripts/BootStrap/plugins/bootcomplete/bootcomplete.css" rel="stylesheet" />

	<script>
		function SelectedItem(source, eventArgs) {
			document.getElementById("hdnSubCd").value = eventArgs.get_value();
			//alert(" Key :" + eventArgs.get_text() + "  Value :  " + eventArgs.get_value());
			//alert(document.getElementById("hdnEntityValue").value);
		}

		function cboAccNo_SelectedIndexChanged() {
			txtBank.SetText(cboAccNo.GetValue().split(",")[1]);
		}

		function cboRecvBank_SelectedIndexChanged() {
			txtRecvAcc.SetText(cboRecvBank.GetValue());
		}

		function cboSegment_SelectedIndexChanged() {
			$("#txtClient").val('');
			//cboAccNo.SetSelectedIndex("-1");
			//$("#txtBank").val('');
		}

		function btnUpload_click(s, e) {
			var uldImage = document.getElementById("uldChequeImage");
			var uploadFile = uldImage.files[0];
			var lblUploadStatus = document.getElementById("lblUploadStatus");

			var permittedExt = [".png", ".jpg", ".jpeg", ".bmp", ".tif", ".tiff"];
			var extAllowed = false;
			for(var index = 0; index < permittedExt.length; index++) {
				var extension = uldImage.value.substr(uldImage.value.length - permittedExt[index].length).toLowerCase();
				extAllowed = permittedExt.includes(extension);
				if(extAllowed) break;
			}

			lblUploadStatus.style.color = "crimson";
			var error = "";
			if(uploadFile.size > 1000000) {
				error = "Image file size must be within 1MB<br>";
			}
			if(extAllowed == false) {
				error += "Image file format allowed are .png, .jpg, .jpeg, .bmp, .tif, .tiff";
			}

			if(error != "") {
				lblUploadStatus.innerHTML = error;
				uldImage.value = null;
				return false;
			}

			return true;
		}

		//function Validate() {
		//	cError = '';
		//	if(cboSegment.GetText() == '') {
		//		cError += 'Segment not selected . . . !\n';
		//	}
		//	if(cboRecvAcc.GetText() == '') {
		//		cError += 'The receiving bank account is not selected . . . !\n';
		//	}
		//	if($('#txtClient').val() == '') {
		//		cError += 'Client not selected . . . !\n';
		//	}
		//	if(cboAccNo.GetText() == '') {
		//		cError += 'The Client\'s bank account is not selected . . . !\n';
		//	}
		//	if(txtAmount.GetText() == 0) {
		//		cError += 'Cheque amount is ZERO . . . !\n';
		//	}
		//	if(!txtChequeNo.GetText().match("^[0-9]{6}$")) {
		//		cError += 'Incorrect cheque number . . . !\n';
		//	}
		//	if(dtCheque.GetValue() == null) {
		//		cError += 'Cheque date not provided . . . !\n';
		//	}

		//	if(cError != 0) {
		//		alert(cError);
		//		return false;
		//	}

		//	return true;
		//}

	</script>

</body>
</html>