﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="InventoryStockEntry.aspx.cs" Inherits="Connect_DotNet.InventoryStockEntry" %>

<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<%@ Register Assembly="ssCommon" Namespace="ssCommon.Controls.BrowserControls" TagPrefix="ss" %>

<!DOCTYPE html>

<html>
<head runat="server">
	<title></title>

	<!-- #CSS Links -->
	<!-- Basic Styles 
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/bootstrap.min.css">
    -->

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
	<!-- Optional theme -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap-theme.min.css" integrity="sha384-rHyoN1iRsVXV4nD0JutlnGaslCJuC7uwjduW9SVrLvRYooPp2bWYgmgJQIXwl/Sp" crossorigin="anonymous">


	<link href="../../css/font-awesome.min.css" rel="stylesheet" />

	<!-- SmartAdmin Styles : Caution! DO NOT change the order -->
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production-plugins.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-skins.min.css">

	<!-- BootComplete http://getwebhelp.com/bootcomplete/ -->
	<link href="../../scripts/BootStrap/plugins/bootcomplete/bootcomplete.css" rel="stylesheet" />

	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">

	<link href="../../css/your_style.css" rel="stylesheet" />
	<link href="../../css/font-awesome-animation.min.css" rel="stylesheet" />

	<style>
		#tblHeader { border:none !important }
		.NoBorder td { border:none !important }
		.AlignMiddle td { vertical-align:middle !important }
	</style>
</head>
<body>
	<div class=container-fluid>
		<h2><i class="fa fa-cubes" aria-hidden="true"></i> Inventory Stock</h2>
		<form id="frmStockEntry" runat="server">
			<asp:ScriptManager ID=ScriptManager1 runat="server"></asp:ScriptManager>
			<div class=row>
				<div class=col-sm-5 style="border-right: 1px solid dimgray; overflow: auto">
					<dx:ASPxTreeView ID=tvwProducts ClientInstanceName=tvwProducts runat="server" OnNodeClick=tvwProducts_NodeClick
						Width=100% Theme=MetropolisBlue Font-Size=Medium>
						<ClientSideEvents EndCallback="function(s, e) { TreeNodeClicked(s, e) }" />
					</dx:ASPxTreeView>
					<ss:ASPxHiddenField ID=hdnProduct ClientInstanceName=hdnProduct runat="server"></ss:ASPxHiddenField>
				</div>
				<div class=col-sm-7>
					<table id=tblHeader class="table table-condensed table-responsive NoBorder AlignMiddle">
						<colgroup><col /><col style="width:20%"/><col style="width:20%"/></colgroup>
						<tr>
							<td>
								<dx:ASPxLabel ID=lblProduct runat="server"></dx:ASPxLabel>
							</td>
							<td rowspan=2>
								<ss:ASPxButton ID=btnAddStock runat="server" Text="Add Stock" CssClass="btn btn-primary" Visible=false>
									<ClientSideEvents Click="function() { AddStock() }" />
								</ss:ASPxButton>
							</td>
							<td rowspan=2>
								<ss:ASPxButton ID=btnTransferStock runat="server" Text="Transfer Stock" CssClass="btn btn-success" Visible=false>
									<ClientSideEvents Click="function() { TransferStock() }" />
								</ss:ASPxButton>
							</td>
						</tr>
						<tr>
							<td>
								<dx:ASPxLabel ID=lblStockInHand runat="server"></dx:ASPxLabel>
							</td>
						</tr>
					</table>
					<dx:ASPxGridView ID=grdTotalStock runat="server" Theme=MetropolisBlue
						Width=100% SettingsBehavior-AllowSort=false>
						<Styles>
							<AlternatingRow BackColor="#f4f4f4"></AlternatingRow>
						</Styles>
						<Columns>
							<dx:GridViewDataColumn FieldName="Particulars" VisibleIndex="1" />
							<dx:GridViewDataTextColumn FieldName="TotalQty" Caption="Total Quantity Received" VisibleIndex="2" ReadOnly=true 
								PropertiesTextEdit-DisplayFormatString="0.00" HeaderStyle-HorizontalAlign=Right />
							<dx:GridViewDataTextColumn FieldName="Holdings" Caption="Stock In Hand" VisibleIndex="3" ReadOnly=true 
								PropertiesTextEdit-DisplayFormatString="0.00" HeaderStyle-HorizontalAlign=Right />
						</Columns>
					</dx:ASPxGridView>
					<dx:ASPxGridView ID=grdProductStock ClientInstanceName=grdProductStock runat="server" Theme=MetropolisBlue Visible=false
						Width=100% SettingsBehavior-AllowSort=false 
						OnCustomCallback=grdProductStock_CustomCallback OnHtmlRowCreated=grdProductStock_HtmlRowCreated>
						<Styles>
							<AlternatingRow BackColor="#f4f4f4"></AlternatingRow>
						</Styles>
						<Columns>
							<dx:GridViewDataColumn FieldName="Npk" Visible=false/>
							<dx:GridViewDataDateColumn FieldName="Stock Entry Date" VisibleIndex="1" 
								PropertiesDateEdit-DisplayFormatString="dd.MMM.yyyy" HeaderStyle-HorizontalAlign=Center CellStyle-HorizontalAlign=Center />
							<dx:GridViewDataColumn FieldName="Supplier" VisibleIndex="2" />
							<dx:GridViewDataTextColumn FieldName="Quantity" Caption="Quantity Received" VisibleIndex="3" ReadOnly=true 
								PropertiesTextEdit-DisplayFormatString="0.00" HeaderStyle-HorizontalAlign=Right />
							<dx:GridViewDataHyperLinkColumn Caption="Action" VisibleIndex="4" CellStyle-Cursor="pointer" HeaderStyle-Cursor="default">
								<DataItemTemplate>
									<a onclick='UpdateStock(<%# Eval("npk") %>);'>Edit</a>
								</DataItemTemplate>
							</dx:GridViewDataHyperLinkColumn>
							<dx:GridViewDataHyperLinkColumn Caption="Action" VisibleIndex="5" CellStyle-Cursor="pointer" HeaderStyle-Cursor="default">
								<DataItemTemplate>
									<a onclick='DeleteStock(<%# Eval("npk") %>);'>Delete</a>
								</DataItemTemplate>
							</dx:GridViewDataHyperLinkColumn>
						</Columns>
					</dx:ASPxGridView>
				</div>
			</div>
		</form>
	</div>

	<!--================================================== -->

	<script src="../../js/libs/jquery-2.1.1.min.js"></script>
	<script src="../../js/bootstrap/bootstrap.min.js"></script>
    -->

    <script  src="https://code.jquery.com/jquery-3.7.1.min.js"  integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo="  crossorigin="anonymous"></script>
    <script  src="https://code.jquery.com/ui/1.14.0/jquery-ui.min.js"  integrity="sha256-Fb0zP4jE3JHqu+IBB9YktLcSjI1Zc6J2b6gTjB0LpoM="  crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>


	<!-- StanSoft Script -->
	<script src="../../scripts/ssajax.js"></script>

	<script>
		function AddStock() {
			var opts = {
				type: "OKCANCEL",
				url: "dotnet/InventoryManagement/InventoryStockAddEdit.aspx?ProductCd=" + hdnProduct.Get("ProductCd"),
				title: "<i class='fa fa-cubes'></i> Add Stock",
				savecaption: "<i class=\"fa fa-floppy-o\"></i> Save",
				cancelcaption: "<i class=\"fa fa-times\"></i> Cancel",
				width: 550,
				height: 250,
				reload: false,
				fnpostsuccess: function () { grdProductStock.PerformCallback("refresh"); },
				reloadwindow: window
			};
			parent.urlFormDialog(opts);

			return false();
		}

		function UpdateStock(npk) {
			var opts = {
				type: "OKCANCEL",
				url: "dotnet/InventoryManagement/InventoryStockAddEdit.aspx?npk=" + npk,
				title: "<i class='fa fa-cubes'></i> Edit Stock",
				savecaption: "<i class=\"fa fa-floppy-o\"></i> Save",
				cancelcaption: "<i class=\"fa fa-times\"></i> Cancel",
				width: 550,
				height: 250,
				reload: false,
				fnpostsuccess: function () { grdProductStock.PerformCallback("refresh"); },
				reloadwindow: window
			};
			parent.urlFormDialog(opts);
		}

		function DeleteStock(npk) {
			var result = confirm("Do you really want to delete this entry?");
			if(result) {
				$.ajax({
					type: "POST",
					url: "InventoryStockEntry.aspx/DeleteStock",
					data: "{npk:'" + npk + "'}",
					contentType: "application/json; charset=utf-8",
					dataType: "json",
					success: function () {
						grdProductStock.PerformCallback("refresh");
					},
					failure: function (response) {
						alert(response.d);
					}
				})
			}
		}

		function TransferStock() {
			var opts = {
				type: "OKCANCEL",
				//url: "InventoryTransfer.aspx?ProductCd=" + hdnProduct.Get("ProductCd"),
				url: "dotnet/InventoryManagement/InventoryTransfer.aspx?ProductCd=" + hdnProduct.Get("ProductCd"),
				title: "<i class='fa fa-cubes'></i> Stock Transfer",
				savecaption: "<i class=\"fa fa-floppy-o\"></i> Save",
				cancelcaption: "<i class=\"fa fa-times\"></i> Cancel",
				width: 550,
				height: 370,
				reload: false,
				fnpostsuccess: function () { grdProductStock.PerformCallback("refresh"); },
				reloadwindow: window
			};
			parent.urlFormDialog(opts);

			return false();
		}
	</script>
</body>
</html>
