﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="AddEdit_Bank_Account.aspx.cs" Inherits="Connect_DotNet.AddEdit_Bank_Account" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<!DOCTYPE html>

<html>
<head runat="server">
	<title></title>
	<!-- #CSS Links -->
	<!-- Basic Styles -->
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/bootstrap.min.css">
	<link href="../../css/font-awesome.min.css" rel="stylesheet" />

	<!-- BootComplete http://getwebhelp.com/bootcomplete/ -->
	<link href="../../scripts/BootStrap/plugins/bootcomplete/bootcomplete.css" rel="stylesheet" />

	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">

	<link href="../../css/your_style.css" rel="stylesheet" />
	<link href="../../css/font-awesome-animation.min.css" rel="stylesheet" />

	<style type="text/css">
		#tblInput { border:none }
		#tblInput td, #tblInput th { border:none;vertical-align:middle;padding:2px !important }

		.alignRight { text-align: right; }

		.completionList {overflow-y:auto;background-color:white;border:1px solid silver;margin:0;padding:3px }
		.listItem { color:black;padding:3px }
		.itemHighlighted { background-color:lightyellow;padding:3px }
	</style>

</head>
<body>
	<div class="container-fluid">
		<br />
		<form id="frmBankAddEdit" runat="server">
			<asp:ScriptManager ID="ScriptManager1" runat="server" EnablePageMethods="true" EnablePartialRendering="true">
			</asp:ScriptManager>
			<div>
				<table id="tblInput" class="table table-condensed table-responsive borderless">
					<colgroup>
						<col style="width: 30%"/><col style="width: 68%"/>
						<col style="width: 1%"/><col style="width: 1%"/>
					</colgroup>
					<tr>
						<td class="alignRight">
							<dx:ASPxLabel ID=ShLabel1 runat="server" Text="Type :"></dx:ASPxLabel>
						</td>
						<td>
							<dx:ASPxComboBox ID=cboType ClientInstanceName="cboType" runat="server" 
								Width="100%" CssClass="form-control input-sm">
								<Items>
									<dx:ListEditItem Text="Primary" Selected="true" Value="Primary" />
									<dx:ListEditItem Text="Secondary" Value="Secondary" />
								</Items>
							</dx:ASPxComboBox>
						</td>
						<td></td>
						<td></td>
					</tr>
					<tr>
						<td class="alignRight">
							<dx:ASPxLabel ID=ShLabel40 runat="server" Text="Bank :"></dx:ASPxLabel>
						</td>
						<td>
							<ajaxToolkit:AutoCompleteExtender ID=AutoCompleteExtenderBank runat="server"
								CompletionListCssClass="completionList"
								CompletionListItemCssClass="listItem"
								CompletionListHighlightedItemCssClass="itemHighlighted"
								ServiceMethod="GetBankCompletionList"
								MinimumPrefixLength="1"
								CompletionInterval="10"
								EnableCaching="false"
								TargetControlID="txtBank"
								FirstRowSelected="false"
								OnClientItemSelected="SelectedItemBank">
							</ajaxToolkit:AutoCompleteExtender>
							<asp:HiddenField ID=hdnBankCode runat="server" />
							<asp:TextBox ID=txtBank runat="server" placeholder="Mandatory" Width="100%" 
								CssClass="form-control input-sm" AutoPostBack="True" OnTextChanged="txtBank_TextChanged">
							</asp:TextBox>
						</td>
					</tr>
					<tr>
						<td class="alignRight">
							<dx:ASPxLabel ID=ShLabel2 runat="server" Text="RTGS / IFSC Code:"></dx:ASPxLabel>
						</td>
						<td>
							<dx:ASPxTextBox ID=txtRTGSNo runat="server" Width="100%" MaxLength="100" ReadOnly="true" 
								CssClass="form-control input-sm">
							</dx:ASPxTextBox>
						</td>
					</tr>
					<tr>
						<td class="alignRight">
							<dx:ASPxLabel ID=ShLabel4 runat="server" Text="MICR No:"></dx:ASPxLabel>
						</td>
						<td>
							<dx:ASPxTextBox ID=txtMICRNo runat="server" Width="100%" MaxLength="100" ReadOnly="true" 
								CssClass="form-control input-sm">
							</dx:ASPxTextBox>
						</td>
					</tr>
					<tr>
						<td class="alignRight">
							<dx:ASPxLabel ID=ShLabel5 runat="server" Text="Account No:"></dx:ASPxLabel>
						</td>
						<td>
							<dx:ASPxTextBox ID=txtAccountNo placeholder="Mandatory" runat="server" Width="100%" 
								MaxLength="20" CssClass="form-control input-sm">
							</dx:ASPxTextBox>
						</td>
					</tr>
					<tr>
						<td class="alignRight">
							<dx:ASPxLabel ID=ShLabel6 runat="server" Text="Account Type:"></dx:ASPxLabel>
						</td>
						<td>
							<dx:ASPxComboBox ID=cboAccountType ClientInstanceName="cboAccountType" runat="server" 
								Width="100%" CssClass="form-control input-sm">
								<Items>
									<dx:ListEditItem Text="Current" Selected="true" Value="Current" />
									<dx:ListEditItem Text="Others" Value="Others" />
									<dx:ListEditItem Text="Savings" Value="Savings" />
									<dx:ListEditItem Text="PIS A/c" Value="PIS A/c" />
								</Items>
							</dx:ASPxComboBox>
						</td>
					</tr>
					<tr>
						<td class="alignRight">
							<dx:ASPxLabel ID=ShLabel3 runat="server" Text="Client Name :"></dx:ASPxLabel>
						</td>
						<td>
							<dx:ASPxTextBox ID=txtClientName runat="server" Width="100%" MaxLength="40" 
								CssClass="form-control input-sm">
							</dx:ASPxTextBox>
						</td>
					</tr>
				</table>
			</div>
		</form>
	</div>
	<script>
        function SelectedItemBank(source, eventArgs) {
            document.getElementById("hdnBankCode").value = eventArgs.get_value();
        }
	</script>
</body>
</html>
