﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="KycCrossVerification.aspx.cs" Inherits="Connect_DotNet.KycCrossVerification" %>

<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<!DOCTYPE html>

<html>
<head runat="server">
	<title></title>

	<!-- Basic Styles -->
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/bootstrap.min.css">
	<link href="../../css/font-awesome.min.css" rel="stylesheet" />

	<!-- SmartAdmin Styles : Caution! DO NOT change the order -->
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production-plugins.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-skins.min.css">
	
	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">

	<link href="../../css/your_style.css" rel="stylesheet" />
    <link href="../../css/font-awesome-animation.min.css" rel="stylesheet" />

	<style>
		#tblInput td, #tblInput th { border:none;padding:2px !important }
		#tblInput td:nth-child(1) { text-align:right;vertical-align:middle }
	</style>
</head>
<body>
	<div class="container-fluid">
		<h2><i class="fa fa-cheque-square-o" aria-hidden="true"></i> KYC Cross Verification</h2>
		<div class="row">
			<div class="col-md-8">
				<form id="frmKycCrossVer" runat="server">
					<table id="tblInput" class="table table-condensed table-responsive">
						<colgroup><col style="width:10%"/><col style="width:7%"/><col style="width:48%"/><col style="width:35%"/></colgroup>
						<tr>
							<td style="text-align:right">PAN :</td>
							<td colspan="2">
								<dx:ASPxTextBox ID=txtPan ClientInstanceName="txtPan" NullText="Mandatory . . ." Width="50%" MaxLength="10" runat="server" CssClass="form-control input-sm"></dx:ASPxTextBox>
							</td>
							<td></td>
						</tr>
						<tr>
							<td style="text-align:right">Name :</td>
							<td colspan="2">
								<dx:ASPxTextBox ID=txtName ClientInstanceName="txtName" NullText="Mandatory . . ." MaxLength="75" runat="server" CssClass="form-control input-sm"></dx:ASPxTextBox>
							</td>
							<td></td>
						</tr>
						<tr>
							<td style="text-align:right">Mobile :</td>
							<td><dx:ASPxTextBox ID=txtStd runat="server" ReadOnly="true" CssClass="form-control input-sm" Text="91"></dx:ASPxTextBox></td>
							<td>
								<dx:ASPxTextBox ID=txtMobile ClientInstanceName="txtMobile" NullText="Mandatory . . ." Width="52%" MaxLength="10" runat="server" CssClass="form-control input-sm"></dx:ASPxTextBox>
							</td>
							<td></td>
						</tr>
						<tr>
							<td style="text-align:right">Email :</td>
							<td colspan="2">
								<dx:ASPxTextBox ID=txtEmail ClientInstanceName="txtEmail" NullText="Mandatory . . ." MaxLength="80" runat="server" CssClass="form-control input-sm"></dx:ASPxTextBox>
							</td>
							<td></td>
						</tr>
						<tr>
							<td colspan="2"></td>
							<td style="text-align:right">
								<dx:ASPxButton ID=btnVerify Text="Verify" runat="server" OnClick="btnVerify_Click" CssClass="btn btn-primary">
									<ClientSideEvents Click="function(s,e){ e.processOnServer = Validate(); }" />
								</dx:ASPxButton>
							</td>
							<td></td>
						</tr>
					</table>		
				</form>
			</div>
		</div>
	</div>

	<script src="../../js/libs/jquery-2.1.1.min.js"></script>
		
	<!-- BOOTSTRAP JS -->
	<script src="../../js/bootstrap/bootstrap.min.js"></script>

	<script>

		function Validate()
		{
			cError = '';
			if(txtPan.GetText() == '') {
				cError += 'PAN is mandatory . . . !\n';
			}
			else if(!txtPan.GetText().trim().match("^[A-Z]{5}[0-9]{4}[A-Z]{1}$")) {
				cError += 'Invalid PAN . . . !\n';
			}
			if(txtName.GetText() == '')
			{
				cError += 'Name is mandatory . . . !\n';
			}
			if(txtMobile.GetText() == '')
			{
				cError += 'Mobile is mandatory . . . !\n';
			}
			else if(!txtMobile.GetText().trim().match("^[0-9]{10}$")) {
				cError += 'Invalid Mobile No. . . . !\n';
			}
			if(txtEmail.GetText() == '')
			{
				cError += 'Email is mandatory . . . !\n';
			}
			else if(!txtEmail.GetText().trim().match("^[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*@([0-9a-z]|[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*)+\.(([a-z]{2}\.[a-z]{2})|[a-z]{2,3})$")) {
				cError += 'Invalid Email . . . !\n';
			}

			if(cError != 0)
			{
				alert(cError);
				return false;
			}

			return true;
		}

	</script>
</body>
</html>
