﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Client_MtfRequest.aspx.cs" Inherits="Connect_DotNet.Client_MtfRequest" %>

<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<!DOCTYPE html>

<html>
<head runat="server">
	<title>Client - MTF Request</title>

	<!-- Basic Styles -->
    <!--
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/bootstrap.min.css">
        -->

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
	<!-- Optional theme -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap-theme.min.css" integrity="sha384-rHyoN1iRsVXV4nD0JutlnGaslCJuC7uwjduW9SVrLvRYooPp2bWYgmgJQIXwl/Sp" crossorigin="anonymous">

	<link href="../../css/font-awesome.min.css" rel="stylesheet" />

	<!-- SmartAdmin Styles : Caution! DO NOT change the order -->
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production-plugins.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-skins.min.css">

	<!-- BootComplete http://getwebhelp.com/bootcomplete/ -->
	<link href="../../scripts/BootStrap/plugins/bootcomplete/bootcomplete.css" rel="stylesheet" />

	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">

	<link href="../../css/your_style.css" rel="stylesheet" />
	<link href="../../css/font-awesome-animation.min.css" rel="stylesheet" />

	<style>
		#btnSubmit, #chkAgree { font-size: 16px; font-weight: bold; }
		.label { color: black !important; font-size: 12px; }

		.table { border:none !important }
		.borderless { border:none !important }
		.borderless td { border:none !important }

		#grdTrades_DXStatus { display:none }
	</style>
</head>
<body>
	<div class="container-fluid">
		<form id="frmClMtfReq" runat="server">
			<div class="row" id="divTop" runat="server">
				<div class="col-sm-12">
					<table class="table table-condensed table-responsive borderless" style="margin:0">
						<tr>
							<td>
								<h5 style="margin:0;padding:0">Trade Confirmations</h5>
							</td>
						</tr>
						<tr>
							<td>
								Date : <dx:ASPxLabel ID="lblDate" runat="server"></dx:ASPxLabel>
							</td>
						</tr>
						<tr>
							<td>
								The following trades were executed. Please mark for MTF.
							</td>
						</tr>
						<%--<tr>
							<td>
								<dx:ASPxHyperLink ID="lnkSelectAll" ClientInstanceName="lnkSelectAll" runat="server" Text="Select All" Cursor="pointer">
									<ClientSideEvents Click="function(s,e) { lnkSelectAll_Click(); }" />
								</dx:ASPxHyperLink>
							</td>
						</tr>--%>
					</table>
				</div>
			</div>
			<div class="row" id="divGrid" runat="server">
				<div class="col-sm-12">
					<dx:ASPxGridView ID="grdTrades" ClientInstanceName="grdTrades" runat="server" Theme="MetropolisBlue" Width="100%"
						KeyFieldName="Npk" OnRowUpdating="grdTrades_RowUpdating" OnHtmlRowPrepared="grdTrades_HtmlRowPrepared"> 
						<Styles>
							<AlternatingRow BackColor="#cfe0e8"></AlternatingRow>
							<Header BackColor="#667292" ForeColor="White" Wrap="True"></Header>
						</Styles>
						<Columns>
							<dx:GridViewDataColumn FieldName="Co" Visible="false" VisibleIndex="0"></dx:GridViewDataColumn>
							<dx:GridViewDataColumn FieldName="TrDt" Visible="false" VisibleIndex="1"></dx:GridViewDataColumn>
							<dx:GridViewDataColumn FieldName="SubCd" Visible="false" VisibleIndex="2"></dx:GridViewDataColumn>
							<dx:GridViewDataColumn FieldName="ItemCd" Visible="false" VisibleIndex="3"></dx:GridViewDataColumn>
							<dx:GridViewDataCheckColumn FieldName="IsSelected" Caption=" " VisibleIndex="4" Width="3%">
								<PropertiesCheckEdit ClientInstanceName="IsSelected">
									<ClientSideEvents CheckedChanged="function(s,e) { IsSelected_CheckedChanged(s,e); }" />
								</PropertiesCheckEdit>
							</dx:GridViewDataCheckColumn>
							<dx:GridViewDataColumn FieldName="Share" Caption="Share Name" VisibleIndex="5" ReadOnly="true"></dx:GridViewDataColumn>
							<dx:GridViewDataColumn FieldName="Exchange" Caption="Exchange" VisibleIndex="6" ReadOnly="true" Width="7%"></dx:GridViewDataColumn>
							<dx:GridViewDataTextColumn FieldName="BuySale" Caption="Transaction Type" VisibleIndex="7" ReadOnly="true" Width="10%">
								<PropertiesTextEdit ClientInstanceName="BuySale"></PropertiesTextEdit>
							</dx:GridViewDataTextColumn>
							<dx:GridViewDataTextColumn FieldName="Qty" Caption="No. of Shares" VisibleIndex="8" ReadOnly="true" Width="10%">
								<PropertiesTextEdit ClientInstanceName="Qty" DisplayFormatString="{0:N0}" Style-HorizontalAlign="Right" 
									DisplayFormatInEditMode="true">
								</PropertiesTextEdit>
							</dx:GridViewDataTextColumn>
							<dx:GridViewDataTextColumn FieldName="Holdings" Caption="Holdings" VisibleIndex="8" ReadOnly="true" Width="10%">
								<PropertiesTextEdit ClientInstanceName="Holdings" DisplayFormatString="{0:N3}" Style-HorizontalAlign="Right" 
									DisplayFormatInEditMode="true">
								</PropertiesTextEdit>
							</dx:GridViewDataTextColumn>
							<dx:GridViewDataSpinEditColumn FieldName="FundedQty" Caption="Funded Quantity" VisibleIndex="9" Width="10%">
								<PropertiesSpinEdit MinValue="0" ClientInstanceName="FundedQty" AllowNull="false" Style-HorizontalAlign="Right" 
									DisplayFormatString="{0:N0}" DisplayFormatInEditMode="true">
									<SpinButtons ClientVisible="false"></SpinButtons>
									<ClientSideEvents LostFocus="function(s,e) { FundedQty_LostFocus(s,e); }" />
								</PropertiesSpinEdit>
								<CellStyle BackColor="#e3eaa7"></CellStyle>
							</dx:GridViewDataSpinEditColumn>
							<dx:GridViewDataTextColumn FieldName="ActRate" Caption="Actual Rate" VisibleIndex="10" ReadOnly="true" Width="10%">
								<PropertiesTextEdit ClientInstanceName="ActRate" Style-HorizontalAlign="Right"
									DisplayFormatInEditMode="true"></PropertiesTextEdit>
							</dx:GridViewDataTextColumn>
							<dx:GridViewDataTextColumn FieldName="NetRate" Caption="Net Rate" VisibleIndex="11" ReadOnly="true" Width="10%">
								<PropertiesTextEdit ClientInstanceName="NetRate" Style-HorizontalAlign="Right"
									DisplayFormatInEditMode="true"></PropertiesTextEdit>
							</dx:GridViewDataTextColumn>
							<dx:GridViewDataTextColumn FieldName="FundedVal" Caption="Funded Value" VisibleIndex="12" ReadOnly="true" Width="15%">
								<PropertiesTextEdit ClientInstanceName="FundedVal" DisplayFormatString="{0:N2}" Style-HorizontalAlign="Right"
									DisplayFormatInEditMode="true">
								</PropertiesTextEdit>
							</dx:GridViewDataTextColumn>
							<dx:GridViewDataColumn FieldName="Type" Visible="false" VisibleIndex="13"></dx:GridViewDataColumn>
							<dx:GridViewDataColumn FieldName="Npk" Visible="false" VisibleIndex="14"></dx:GridViewDataColumn>
						</Columns>
						<SettingsEditing Mode="Batch">
							<BatchEditSettings EditMode="Row" />
						</SettingsEditing>
						<Settings VerticalScrollBarMode="Visible" VerticalScrollableHeight="200" />
						<SettingsPager Mode="ShowAllRecords"></SettingsPager>
					</dx:ASPxGridView>
				</div>
			</div>
			<div class="row" id="divSummary" runat="server">
				<div class="col-xs-12" style="text-align:right">
					<table class="table table-condensed table-responsive" style="margin:0">
						<colgroup>
							<col style="width:70%"/><col style="width:20%"/><col style="width:10%"/>
						</colgroup>
						<tr>
							<td style="border:none"></td>
							<td style="border-top:none">Current Funding :</td>
							<td style="border-top:none">
								<dx:ASPxLabel ID="lblCurrent" ClientInstanceName="lblCurrent" runat="server" Text="0.00"></dx:ASPxLabel>
							</td>
						</tr>
						<tr>
							<td style="border:none"></td>
							<td>Fresh Funding :</td>
							<td>
								<dx:ASPxLabel ID="lblFreshSum" ClientInstanceName="lblFreshSum" runat="server" Text="0.00"></dx:ASPxLabel>
							</td>
						</tr>
						<tr>
							<td style="border:none"></td>
							<td>Funding Release :</td>
							<td>
								<dx:ASPxLabel ID="lblReleaseSum" ClientInstanceName="lblReleaseSum" runat="server" Text="0.00"></dx:ASPxLabel>
							</td>
						</tr>
						<tr>
							<td style="border:none"></td>
							<td>Final Funding :</td>
							<td>
								<dx:ASPxLabel ID="lblFinal" ClientInstanceName="lblFinal" runat="server" Text="0.00"></dx:ASPxLabel>
							</td>
						</tr>
						<tr><td style="border:none"></td><td></td><td></td></tr>
						<tr><td style="border:none"></td><td></td><td></td></tr>
					</table>
				</div>
			</div>
			<div class="row" id="divSubmit" runat="server" style="background-color: lightskyblue; padding: 10px">
				<div class="col-sm-3"></div>
				<div class="col-sm-4" style="padding-right: 2px !important">
					<dx:ASPxCheckBox ID="chkAgree" ClientInstanceName="chkAgree" runat="server" Theme="MetropolisBlue" RootStyle-VerticalAlign="Top"
						Text="I agree that I have understood the terms and conditions and want to avail MTF for the above selected positions.">
						<ClientSideEvents CheckedChanged="function(s,e) { 
							btnSubmit.SetEnabled(chkAgree.GetChecked());
						}" />
					</dx:ASPxCheckBox>
				</div>
				<div class="col-sm-2" style="padding-left: 2px !important">
					<dx:ASPxButton ID="btnSubmit" ClientInstanceName="btnSubmit" runat="server" Text="Submit"
						HoverStyle-BackColor="ForestGreen" Theme="MetropolisBlue"
						OnClick="btnSubmit_Click">
						<ClientSideEvents Click="function(s,e) { btnSubmit_Click(s,e); }" />
					</dx:ASPxButton>
				</div>
				<div class="col-sm-3"></div>
			</div>

			<div id="divWait" style="text-align: center; position: fixed; top: 30%; left: 40%; visibility: hidden; z-index: 100000; border: 1px solid lightgray; border-radius: 15px; box-shadow: 0px 0px 10px black; background-color: white; padding: 10px">
				<i class="fa fa-spinner fa-4x fa-pulse fa-fw" aria-hidden="true"></i>
				<h6>Please Wait.....</h6>
			</div>

			<div class="row">
				<div class="col-xs-12">
					<div id="divSuccessful" runat="server" width="100%" visible="false">
						<h1 class="text-center text-success">
							<i class="fa fa-check"></i> Congratulations . . . !
							<br />
							<small>Your MTF request have been saved successfully for processing.</small>
							<br />
							<small>Thank You !</small>
						</h1>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-xs-12">
					<div id="divAlreadyRequested" runat="server" width="100%" visible="false">
						<h1 class="text-center text-warning">
							<i class="fa fa-info-circle"></i> Information . . . !
							<br />
							<small>You have already requested for MTF.</small>
							<br />
							<small>Your MTF request is under processing.</small>
							<br />
							<small>For further query or information please contact us via phone or email.</small>
							<br />
							<small>Thank You !</small>
						</h1>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-xs-12">
					<div id="divMtfReg" runat="server" width="100%" visible="false">
						<h1 class="text-center text-warning">
							<i class="fa fa-info-circle"></i> Information . . . !
							<br />
							<small>You have to register for MTF before availing this facility.</small>
							<br />
							<small>You may register for MTF from your dashboard by clicking on <b>Register for MTF</b> button.</small>
							<br />
							<small>Thank You !</small>
						</h1>
					</div>
				</div>
			</div>
		</form>
		<%--<div style="height: 100px"></div>--%>
	</div>

	<!--================================================== -->
	<!--
    <script src="../../js/libs/jquery-2.1.1.min.js"></script>
	<script src="../../js/bootstrap/bootstrap.min.js"></script>
        -->

    <script  src="https://code.jquery.com/jquery-3.7.1.min.js"  integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo="  crossorigin="anonymous"></script>
    <script  src="https://code.jquery.com/ui/1.14.0/jquery-ui.min.js"  integrity="sha256-Fb0zP4jE3JHqu+IBB9YktLcSjI1Zc6J2b6gTjB0LpoM="  crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>


	<script>
		$(document).ready(function () {
			btnSubmit.SetEnabled(chkAgree.GetChecked());

			var current = parseFloat(lblCurrent.GetText());
			lblCurrent.SetText(current.toFixed(2));
			lblFinal.SetText(current.toFixed(2));
		});

		function btnSubmit_Click(s, e) {
			var isConfirm = confirm("Once you submit, you will not be able to modify your selection.\nPlease check your selections before you submit.\nAre you sure to submit . . . ?");
			e.ProcessOnServer = isConfirm;

			//if(e.processOnServer) $('#divWait').css('visibility', 'visible');
		}

		function FundedQty_LostFocus(s, e) {
			var QtyAvailable = parseInt(Holdings.GetText());
			if(BuySale.GetText() == "Purchase") {
				QtyAvailable = parseInt(Qty.GetText());
			}

			var QtyReq = parseInt(FundedQty.GetText());
			if(QtyReq < 0 || QtyReq > QtyAvailable) {
				QtyReq = QtyAvailable;
				s.SetText(QtyAvailable);
			}

			var multiplier = 1
			if(BuySale.GetText() == 'Purchase') multiplier = -1;

			FundedVal.SetText(QtyReq * parseFloat(NetRate.GetText()) * multiplier);

			grdTrades.UpdateEdit();
		}

		function IsSelected_CheckedChanged(s, e) {
			CalculateFundedValSummary(-1);

			if(s.GetChecked()) {
				FundedQty.SetText(Holdings.GetText());
				if(BuySale.GetText() == "Purchase") {
					FundedQty.SetText(Qty.GetText());
				}
			}
			else {
				FundedQty.SetText(0);
			}

			FundedQty_LostFocus(null, null);

			CalculateFundedValSummary(1);
		}

		function CalculateFundedValSummary(multiplier)
		{
			var sumFresh = parseFloat(lblFreshSum.GetText());
			var sumRelease = parseFloat(lblReleaseSum.GetText());
			var fundVal = parseFloat(FundedVal.GetText());

			if(fundVal < 0)
				lblFreshSum.SetText((sumFresh + fundVal*multiplier).toFixed(2));
			else
				lblReleaseSum.SetText((sumRelease + fundVal*multiplier).toFixed(2));

			var current = parseFloat(lblCurrent.GetText());
			sumFresh = parseFloat(lblFreshSum.GetText());
			sumRelease = parseFloat(lblReleaseSum.GetText());
			lblFinal.SetText((current + sumFresh + sumRelease).toFixed(2));
		}

	</script>

</body>
</html>
