﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="livetrades.aspx.cs" Inherits="Connect_DotNet.Mobile.livetrades" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title></title>
    <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  
	<!-- Basic Styles -->
    <!--  Bootstrap v3.3.7 -->
	<!--
        <link rel="stylesheet" type="text/css" media="screen" href="../../css/bootstrap.min.css">
    -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
	<link href="../../css/font-awesome.min.css" rel="stylesheet" />
    <!-- Rev 13-08-2024 [Mithun/Abhay] - We upgraded the versions of Bootstrap and Jquery and used CDN 
		<script src="../../js/libs/jquery-2.1.1.min.js"></script>
	-->
	<script  src="https://code.jquery.com/jquery-3.7.1.min.js"  integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo="  crossorigin="anonymous"></script>
	
    <!-- BOOTSTRAP JS 
		<script src="../../js/bootstrap/bootstrap.min.js"></script>
	-->
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>
    

	<!-- StanSoft Script -->
	<script src="../../scripts/ssajax.js"></script>

    <script type="text/javascript">  
        $(document).ready(function () {  
            setLiveTrades();
            setInterval("setLiveTrades()", 120000);
        });
        

        function setLiveTrades() {
             $.ajax({  
                url: 'LiveTradesService.asmx/GetLiveTradesAvgRate',  
                dataType: "json", 
                data: { subcd: '<%= cSubcd %>',lasttrtime: $('#hdnLastTRDTIME').val() },
                method: 'post',  
                success: function (data) {  
                    var LiveTradesTable = $('#tblLiveTrades tbody');  

                    //http://localhost/shrdbms/dotnet/mobile/livetrades.aspx?sessionid=5TX0OAKK506616

                    var liveTradesData = "";

                    $(data).each(function (index, trade) {  
                        liveTradesData += '<tr class="' + trade.RowClass + '">'+
                                            '<td>Order: ' + trade.TrdOrdno + ' <br>' + trade.TrdProduct + '</td>' +
                                            '<td style="white-space: nowrap;">Time: ' + trade.TrdTime + ' <br>'+ trade.TrdUnit +' '+ trade.TrdStatus + ' <i class="fa fa-inr" aria-hidden="true"></i> ' + trade.TrdRate + '</td>' +
                                          '</tr>';  
                    }); 

                    if (liveTradesData != "") {
                        $("#hTradeRecordsStatus").hide();
                    }
                    else {
                        //No records found...
                        $("#hTradeRecordsStatus").html('<i class="fa fa-exclamation-triangle"  aria-hidden="true"></i> No records found...')
                        $("#hTradeRecordsStatus").css("color", "darkred");
                    }

                    LiveTradesTable.prepend(liveTradesData);
                    $('#hdnLastTRDTIME').val(data[0].TrdTime);

                    //alert(liveTradesData);
                    
                    
                    

                },  
                error: function (err) {  
                    //alert(err);  
                }  
             });

            //alert($('#tblLiveTrades tbody').html());
        }  

    </script>
    </head>
<body  class="bg-success">

    <form id="form1" runat="server">
           <div class="container-fluid">
            <div class="row">
	            <div class="col-lg-12" style="padding-left:0px;padding-right:0px; margin-bottom:8%">
                    <table id="tblLiveTrades" class="table table-striped" style="font-size:12px; border-bottom:groove">
                            <thead>
                               <tr>
                                <th>
                                <h2><i class="fa fa-calendar" aria-hidden="true"></i> Today's orders  </h2>
                                    
                                </th>
                                   <th>
                                       
                                           <button type="button" class="btn btn-sm btn-primary pull-right"  style="margin-top: 18px;   margin-bottom: 9px;"  onclick="setLiveTrades();"><i class="fa fa-refresh" aria-hidden="true"></i></button>

                                   </th>
                                
                              </tr>
                            </thead>
                    <tbody id="tbodyTrades">
                    </tbody>
                    </table>
                    <h4 style="text-align:center;" id="hTradeRecordsStatus"><i class="fa fa-spinner" aria-hidden="true"></i> Loading...</h4>
                    </div>
            </div>
              <input type="hidden" id="hdnLastTRDTIME" value="" name="hiddenLastTRDTIME">

            </div>
    </form>
</body>
</html>
