﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="PageResponseAnalysis.aspx.cs" Inherits="Connect_DotNet.PageResponseAnalysis" %>

<%@ Register Assembly="ssCommon" Namespace="ssCommon.Controls.BrowserControls" TagPrefix="ss" %>

<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title></title>

	<!-- Basic Styles -->

    <!--
	<link rel="stylesheet" type="text/css" media="screen" href="../css/bootstrap.min.css">
    -->

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
	<!-- Optional theme -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap-theme.min.css" integrity="sha384-rHyoN1iRsVXV4nD0JutlnGaslCJuC7uwjduW9SVrLvRYooPp2bWYgmgJQIXwl/Sp" crossorigin="anonymous">

	<link href="../css/font-awesome.min.css" rel="stylesheet" />

	<!-- SmartAdmin Styles : Caution! DO NOT change the order -->
	<link rel="stylesheet" type="text/css" media="screen" href="../css/smartadmin-production-plugins.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../css/smartadmin-production.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../css/smartadmin-skins.min.css">

	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">
	
	<link href="../css/your_style.css" rel="stylesheet" />

	<style>
		.NoBorder td { border:none !important; padding:2px !important }
		.AlignMiddle td { vertical-align:middle !important }
	</style>
</head>
<body>
	<div class="container-fluid">
	<h2><i class="fa fa-money" aria-hidden="true"></i> Web Page Response Analysis</h2>
	<asp:Panel ID=pnlAccessMessage runat="server" Visible=false>
		<h2 style="text-align:center">You do not have permission to view the contents of this page.</h2>
	</asp:Panel>
	<asp:Panel ID=pnlData runat="server">
		<form id="frmAnalysis" runat="server">
			<div class="row">
				<div class="col-sm-7">
					<table class="table table-responsive table-condensed NoBorder AlignMiddle">
						<tr>
							<td>From :</td>
							<td>
								<dx:ASPxDateEdit ID=dtFrom runat="server" CssClass="form-control input-sm" Theme=MetropolisBlue></dx:ASPxDateEdit>
							</td>
							<td>To :</td>
							<td>
								<dx:ASPxDateEdit ID=dtTo runat="server" CssClass="form-control input-sm" Theme=MetropolisBlue></dx:ASPxDateEdit>
							</td>
							<td>
								<ss:ASPxButton ID=btnView runat="server" Text="View" CssClass="btn btn-primary btn-sm" OnClick=btnView_Click></ss:ASPxButton>
							</td>
						</tr>
					</table>
				</div>
			</div>
			<div class=row>
				<div class=col-sm-12>
					<dx:ASPxGridView ID=grdAnlytics runat="server" ClientInstanceName=grdAnlytics Theme=MetropolisBlue 
							Width=100% AutoGenerateColumns=false>
							<Styles>
								<AlternatingRow BackColor="#f4f4f4"></AlternatingRow>
							</Styles>
							<Columns>
								<dx:GridViewDataTextColumn FieldName="time" Caption="Hit Date-Time" 
									PropertiesTextEdit-DisplayFormatString="dd.MMM.yyyy hh:mm:ss tt" 
									HeaderStyle-HorizontalAlign=Center CellStyle-HorizontalAlign=Center 
									ReadOnly=true VisibleIndex="1" />
								<dx:GridViewDataColumn FieldName="querystr" Caption="Query String" VisibleIndex="2" />
								<dx:GridViewDataColumn FieldName="script" Caption="Script \ Page" VisibleIndex="3" />
								<dx:GridViewDataColumn FieldName="remoteaddr" Caption="Remote Address" VisibleIndex="4"  />
								<dx:GridViewDataColumn FieldName="duration" CellStyle-HorizontalAlign=Right
									HeaderStyle-HorizontalAlign=Right Caption="Response Time (in sec.)" VisibleIndex="5" />
								<dx:GridViewDataColumn FieldName="memused" CellStyle-HorizontalAlign=Right
									HeaderStyle-HorizontalAlign=Right Caption="Memory Used (in bytes)" VisibleIndex="6" />
								<dx:GridViewDataColumn FieldName="error" Caption="Error" VisibleIndex="7" />
								<dx:GridViewDataColumn FieldName="reqdata" Caption="Request Data" VisibleIndex="8" />
								<dx:GridViewDataColumn FieldName="browser" Caption="Browser" VisibleIndex="9" />
							</Columns>
					</dx:ASPxGridView>
				</div>
			</div>
		</form>
	</asp:Panel>
	</div>

    <!--
	<script src="../js/libs/jquery-2.1.1.min.js"></script>
    -->
	<!-- BOOTSTRAP JS 
	<script src="../js/bootstrap/bootstrap.min.js"></script>
        -->

    <script  src="https://code.jquery.com/jquery-3.7.1.min.js"  integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo="  crossorigin="anonymous"></script>
    <script  src="https://code.jquery.com/ui/1.14.0/jquery-ui.min.js"  integrity="sha256-Fb0zP4jE3JHqu+IBB9YktLcSjI1Zc6J2b6gTjB0LpoM="  crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>

	<!-- ssAjax : StanSoft Javascript Library -->
	<script type="text/javascript" src="../scripts/ssajax.js"></script>
</body>
</html>
