﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ConfirmDetails.aspx.cs" Inherits="Connect_DotNet.ReKYC.ConfirmDetails" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title>ReKYC</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Load BootStrap and FontAwesome -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <script src="../eKyc/js/ekyc.js"></script>

    <style>
        body{
            /*background-color:ivory;*/
            background-color: #f8f9fa;
        }

        .margineTop10{
            margin-top:10px
        }

        /* Increase size of checkbox with class .custom-checkbox */
        .confirm-checkbox {
          width: 14px;              /* Width of checkbox */
          height: 14px;             /* Height of checkbox */
          transform: scale(1.5);    /* Increase size visually */
          -webkit-transform: scale(1.5); /* For WebKit browsers */
        }

        .spanHeader{
            font-size:16px;
        }

    </style>

</head>
<body>
    <script>

        function SelectSegment() {
            
            if (document.getElementById("optionSegments").checked == true) {
                document.getElementById("optionIncome").checked = true;
                //document.getElementById("optionIncome").disabled = true;
            }
        }

        // SUBMIT button processing script
        function continueForchanges() {

            // Basic validation
            if (
                document.getElementById('hdnRequestMode').value == "Modification" &&
                document.getElementById('optionMobile').checked == false &&
                document.getElementById('optionEmail').checked == false &&
                document.getElementById('optionDateofBirth').checked == false &&
                document.getElementById('optionIncome').checked == false &&
                document.getElementById('optionAddress').checked == false &&
                document.getElementById('optionSegments').checked == false &&
                document.getElementById('optionBankDetails').checked == false &&
                document.getElementById('optionNomination').checked == false &&
                document.getElementById('optionDPDetails').checked == false &&
                document.getElementById('optionDDPI').checked == false &&
                document.getElementById('optionAuthorizedRepresentative').checked == false) {
                alertModal("Error - Option not selected", "Please choose minimum one parameter that you need to be changed!", "danger");
                return;
            }

            // Construct a Comma-Delimited variable containing the Changes
            var changesParameters = "";

            if (document.getElementById('optionMobile').checked == true) {
                changesParameters = "Mobile";
            }

            if (document.getElementById('optionEmail').checked == true) {

                changesParameters = changesParameters + getCommaByValue(changesParameters) + "Email";
            }

            if (document.getElementById('optionDateofBirth').checked == true) {

                changesParameters = changesParameters + getCommaByValue(changesParameters) + "DOB";
            }

            if (document.getElementById('optionAddress').checked == true) {
                changesParameters = changesParameters + getCommaByValue(changesParameters) + "Address";
            }
            if (document.getElementById('optionIncome').checked == true || document.getElementById('hdnRequestMode').value != "Modification" ) {
                changesParameters = changesParameters + getCommaByValue(changesParameters) + "Income";
            }

            if (document.getElementById('optionSegments').checked == true) {
                changesParameters = changesParameters + getCommaByValue(changesParameters) + "Segments";
            }

            if (document.getElementById('optionBankDetails').checked == true) {
                changesParameters = changesParameters + getCommaByValue(changesParameters) + "Bank";
            }

            if (document.getElementById('optionNomination').checked == true) {
                changesParameters = changesParameters + getCommaByValue(changesParameters) + "Nomination";
            }

            if (document.getElementById('optionDPDetails').checked == true) {
                changesParameters = changesParameters + getCommaByValue(changesParameters) + "DP";
            }

            if (document.getElementById('optionDDPI').checked == true) {
                changesParameters = changesParameters + getCommaByValue(changesParameters) + "DDPI";
            }

            if (document.getElementById('optionAuthorizedRepresentative').checked == true) {
                changesParameters = changesParameters + getCommaByValue(changesParameters) + "Authorized Representative";
            }

            // Set the Changes Parameters as a hidden element to submit
            document.getElementById('hdnBtnRequestClicked').value = changesParameters;
            // Show the loading modal
            showModalLoading();
            // Programmatically click the SUBMIT button and fire the Click event.
            document.getElementById('<%= btnRequest.UniqueID %>').click();
        }

        function getCommaByValue(changesParams) {

            if (changesParams != "") {
                return ",";
            }

            return "";
        }


    </script>
    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <div class="container">
                <div class="row">
                    <div class="col-md-2">
                        <center>
                        <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:180px; height:80px; padding-top:10px">
                        </center>
                    </div>
                    <div class="col-md-10">
                        <h2 class="lblTopHeader"><i class="fa fa-user-pen" aria-hidden="true"></i> ReKYC <span id="spanType" runat="server">Application</span></h2>
                        <p id="paraTitle" runat="server">Please <b>review the information</b> below to ensure it is correct. If you would like to update or add details to specific sections—such as Nominee, Bank, Segment, or DP—kindly select the corresponding items you wish to modify or enhance.</p>
                    </div>
                </div>
                 <div class="row d-flex justify-content-center align-items-center">
                    <div class="col-lg-12">
                        <div class="card text-black" style="border-radius: 25px;">
                            <div class="card-body p-md-5" id="divMain" runat="server">
                                <div class="d-flex flex-row align-items-center mb-4">
                                    <div class="row justify-content-center">
                                        <div class="col-lg-12">
                                            <h1 id="hName" runat="server"></h1>
                                            UCC: <span runat="server" id="spanUCC"></span>&nbsp;&nbsp;
                                            PAN: <span id="spanPAN" runat="server" ></span>
                                            <br />
                                            <br />
                                            <div class="progress">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                                                </div>
                                            </div>
                                            <h3 style="color:red" id="hInactiveMsg" runat="server">Your account has been <b>Inactive</b>. Your last Trade date <span id="spanLastTradeDate" runat="server" style="font-weight:bold"></span>. Please <b>Reactivate</b> your account.</h3>
                                            <div class="modal-dialog" style="width:100%">
                                                <!-- Modal content-->
                                                <div class="modal-content">
                                                  <div class="modal-body">
                                                   <h3>Please <i class="fa fa-solid fa-square-check"></i> choose which parameter(s) need to be changed</h3>
                                                      <br />
                                                    <div id="divDetails">
                                                        <div class="row justify-content-center">
                                                            <div class="col-lg-6">
                                                              <div class="form-outline flex-fill mb-0 margineTop10">
                                                                  <label class="form-label" for="txtMobile">
                                                                      <input type="checkbox" class="form-check-input confirm-checkbox" runat="server" id="optionMobile" name="optionMobile" value="Mobile">&nbsp; <span class="spanHeader">Mobile</span>
                                                                  </label>
                                                                  <input type="number"  class="form-control" id="txtMobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" readonly="readonly" placeholder="NA">
                                                              </div>
                                                            </div>
                                                            <div class="col-lg-6">
                                                              <div class="form-outline flex-fill mb-0 margineTop10">
                                                                  <label class="form-label" for="txtEmail">
                                                                      <input type="checkbox" class="form-check-input confirm-checkbox" runat="server" id="optionEmail" name="optionEmail" value="Email">&nbsp; <span class="spanHeader">Email</span>
                                                                  </label>
                                                                  <input type="email"  class="form-control" id="txtEmail" maxlength="300" runat="server" readonly="readonly" placeholder="NA">
                                                              </div>
                                                            </div>
                                                        </div>
                                                        <div class="row justify-content-center">
                                                            <div class="col-lg-6">
                                                              <div class="form-outline flex-fill mb-0 margineTop10">
                                                                  <label class="form-check-label" for="txtDateofBirth">
                                                                    <input type="checkbox" class="form-check-input confirm-checkbox" runat="server" id="optionDateofBirth" name="optionDateofBirth" value="DOB">&nbsp;&nbsp;<span class="spanHeader">Date of Birth</span>
                                                                  </label>
                                                                  <input type="text"  class="form-control" id="txtDateofBirth" maxlength="300" runat="server" readonly="readonly" placeholder="NA">
                                                              </div>
                                                            </div>
                                                            <div class="col-lg-6">
                                                              <div class="form-outline flex-fill mb-0 margineTop10">
                                                                  <label class="form-label" for="txtIncome">
                                                                      <input type="checkbox" class="form-check-input confirm-checkbox" runat="server" id="optionIncome" name="optionIncome" value="Anual Income">&nbsp; <span class="spanHeader">Anual Income</span>
                                                                  </label>
                                                                  <input type="text"  class="form-control" id="txtIncome" runat="server" readonly="readonly" placeholder="NA">
                                                              </div>
                                                            </div>
                                                        </div>
                                                        <div class="row justify-content-center">
                                                            <div class="col-lg-6">
                                                              <div class="form-outline flex-fill mb-0 margineTop10">
                                                                  <label class="form-label" for="txtAddress">
                                                                      <input type="checkbox" class="form-check-input confirm-checkbox" runat="server" id="optionAddress" name="optionAddress" value="Address">&nbsp; <span class="spanHeader">Address</span>
                                                                  </label>
                                                                  <textarea class="form-control" id="txtAddress" maxlength="500" rows="4" runat="server" readonly="readonly" placeholder="NA"/>
                                                              </div>
                                                            </div>
                                                            <div class="col-lg-6">
                                                              <div class="form-outline flex-fill mb-0 margineTop10">
                                                                  <label class="form-check-label" for="txtSegments">
                                                                    <input type="checkbox" class="form-check-input confirm-checkbox" runat="server" id="optionSegments" name="optionSegments" value="Segments" onclick="SelectSegment()">&nbsp;&nbsp;<span class="spanHeader">Active Segments</span>
                                                                  </label>
                                                                  <textarea class="form-control" id="txtSegments" maxlength="500" rows="4" runat="server" readonly="readonly" placeholder="NA"/>
                                                              </div>
                                                            </div>
                                                        </div>
                                                        <div class="row justify-content-center">
                                                            <div class="col-lg-12">
                                                              <div class="form-outline flex-fill mb-0 margineTop10" style="border-bottom:dotted 1px; border-top:groove 2px; padding-top:10px">
                                                                  <label class="form-check-label" for="optionBankDetails">
                                                                    <input type="checkbox" class="form-check-input confirm-checkbox" runat="server" id="optionBankDetails" name="optionBankDetails" value="Bank">&nbsp;&nbsp;<span class="spanHeader">Bank Details</span>
                                                                  </label>
                                                                  <div class="table-responsive">
                                                                    <table class="table table-striped">
                                                                        <thead class="thead-dark">
                                                                            <tr>
                                                                                <th>Type</th>
                                                                                <th>Bank</th>
                                                                                <th>IFSC</th>
                                                                                <th>MICR</th>
                                                                                <th>Account No.</th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody id="tbodyBanks" runat="server">
                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                              </div>
                                                            </div>
                                                        </div>
                                                        <div class="row justify-content-center">
                                                            <div class="col-lg-12">
                                                              <div class="form-outline flex-fill mb-0 margineTop10" style="border-bottom:dotted 1px">
                                                                  <label class="form-check-label" for="optionNomination">
                                                                    <input type="checkbox" class="form-check-input confirm-checkbox" runat="server" id="optionNomination" name="optionNomination" value="Nomination">&nbsp;&nbsp;<span class="spanHeader">Nomination</span>
                                                                  </label>
                                                                  <div class="table-responsive">
                                                                    <table class="table table-striped">
                                                                        <thead class="thead-dark">
                                                                            <tr>
                                                                                <th>Name</th>
                                                                                <th>Relation</th>
                                                                                <th>Share %</th>
                                                                                <th>Mobile</th>
                                                                                <th>Date of Birth</th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody id="tbodyNominees" runat="server">
                                                                        </tbody>
                                                                    </table>
                                                                  </div>
                                                              </div>
                                                            </div>
                                                        </div>
                                                        <div class="row justify-content-center">
                                                            <div class="col-lg-12">
                                                              <div class="form-outline flex-fill mb-0 margineTop10" >
                                                                  <label class="form-check-label" for="optionDPDetails">
                                                                    <input type="checkbox" class="form-check-input confirm-checkbox" runat="server" id="optionDPDetails" name="optionDPDetails" value="DP">&nbsp;&nbsp;<span class="spanHeader">DP Details</span>
                                                                  </label>
                                                                  <div class="table-responsive">
                                                                    <table class="table table-striped">
                                                                        <thead class="thead-dark">
                                                                            <tr>
                                                                                <th>Type</th>
                                                                                <th>DP Name</th>
                                                                                <th>DP Id</th>
                                                                                <th>Client Id</th>
                                                                                <th>Status</th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody id="tbodyDP" runat="server">
                                                                        </tbody>
                                                                    </table>
                                                                  </div>
                                                              </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="row justify-content-center">
                                                            <div class="col-lg-6">
                                                              <div class="form-outline flex-fill mb-0 margineTop10">
                                                                  <label class="form-check-label" for="txtDDPI">
                                                                    <input type="checkbox" class="form-check-input confirm-checkbox" runat="server" id="optionDDPI" name="optionDDPI" value="DDPI">&nbsp;&nbsp;Activate DDPI
                                                                  </label>: &nbsp
                                                                  <span style="font-size:16px; font-weight:bold" id="spanDDPI" runat="server" ></span>
                                                                 <p style="margin-left:20px">Sell without TPIN</p>
                                                              </div>
                                                            </div>
                                                            <div class="col-lg-6">
                                                                <div style="display:none">
                                                                    <div class="form-outline flex-fill mb-0 margineTop10">
                                                                  <label class="form-check-label" for="txtAuthorizedRepresentative">
                                                                    <input type="checkbox" class="form-check-input confirm-checkbox" runat="server" id="optionAuthorizedRepresentative" name="optionAuthorizedRepresentative" value="AuthorizedRepresentative">&nbsp;&nbsp;Authorized Representative
                                                                  </label>
                                                                  <input type="text"  class="form-control" id="txtAuthorizedRepresentative" maxlength="300" runat="server" readonly="readonly" placeholder="NA">
                                                              </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                  </div>
                                                  <div class="modal-footer" style="text-align:left">
                                                      <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                                                        <ContentTemplate>
                                                            <h4>Please <b>review the information</b> above to ensure it is correct. If you would like to update or add details to specific sections—such as Nominee, Bank, Segment, or DP—kindly select the corresponding items you wish to modify or enhance.</h4>
                                                            <button type="button" class="btn btn-lg btn-primary margineTop10" onclick="continueForchanges()"><i class="fa-solid fa-check"></i> Confirm and Continue</button>
                                                            <div style="display:none">
                                                                <asp:Button ID="btnRequest" runat="server" Text="" OnClick="btnRequest_Click" /> 
                                                                <input type="hidden" id="hdnBtnRequestClicked" name="hdnBtnRequestClicked" runat="server" value="">
                                                            </div>
                                                        </ContentTemplate>
                                                      </asp:UpdatePanel>
                                                      <input type="hidden" id="hdnRequestMode" name="hdnRequestMode" runat="server" value="">
                                                  </div>
                                                </div>

                                              
                                                </div>
                                            
                                            <div class="progress">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                                                </div>
                                            </div>
                                        </div>
                                   </div>
                                 </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div id="divErrorMsg" runat="server" style="margin-top:20px; height: 100%; display:none; width: 100%; text-align: center;">
                                        <div class="alert alert-danger" role="alert">
				                            <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span> <span id="spanError" runat="server"></span>
			                            </div>
                                        <div id="divLinkReKYCStatus" style="display:none" runat="server">
                                            <a id="linkReKYCStatus" runat="server" class="btn btn-info btn-lg">Go to ReKYC Status</a>
                                        </div>
		                            </div>
                                </div>
                           </div>
                        </div>
                    </div>
                </div>
                 <div class="row">
                    <div class="col-sm-6" >

                    </div>
                    <div class="col-sm-6 poweredBy" style="text-align:right;">
                        <span style="font-size:small;text-align:right">Powered by</span></br>
				        <a href="http://www.stansoftware.com">
					        <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						        </a>
			        </div>
                 </div>
        </div>
        
    </form>
    

</body>
</html>
