﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="contact.aspx.cs" Inherits="Connect_DotNet.ReKYC.contact" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title>Verify your Mobile and Email</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <script src="../eKyc/js/ekyc.js"></script>    
</head>
<body>
    <style>
        .margineTop10{
            margin-top:10px
        }
        /*
        body{
            background-color:ivory;
        }*/

        #countdownTimer {
            margin-top: 10px;
            font-size:18px;
        }

        #countdownTimer span{
            font-weight: bold;
        }

    </style>

     <script>

         function startCountdown() {

             $('#modalLoading').modal('hide');

             let countdownTime = 30; // 30 seconds countdown
             let countdownInterval;
             
             document.getElementById('divConfirm').style.display = 'block';

             document.getElementById('btnOTPEmailResend').style.display = 'none';
             document.getElementById('countdownTimer').style.display = 'block';

             let timerElement = document.getElementById('timer');
             timerElement.textContent = countdownTime;

             // Start countdown
             countdownInterval = setInterval(() => {
                 countdownTime--;
                 timerElement.textContent = countdownTime;

                 // When countdown ends
                 if (countdownTime <= 0) {
                     clearInterval(countdownInterval);
                     countdownTime = 30; // Reset countdown time
                     document.getElementById('countdownTimer').style.display = 'none';
                     document.getElementById('btnOTPEmailResend').style.display = 'inline-block';
                 }
             }, 1000);
         }
    </script>
     <script>


         function requestData(reqType) {

             if (document.getElementById('divMobileNew').style.display == "block") {

                 if (!IsMobileNumber(document.getElementById('txtMobileNew'))) {
                     return;
                 }

             }
             
             if (document.getElementById('divEmailNew').style.display == "block") {

                 if (!ValidateEmail(document.getElementById('txtEmailNew'))) {
                     return;
                 }

             }

            document.getElementById('hdnBtnRequestClicked').value = reqType;
             showModalLoading();
             document.getElementById('<%= btnRequest.UniqueID %>').click();


         }


         function IsMobileNumber(number) {

              if (number.value == "") {
                 alertModal("Opps! Problem with the Mobile Number", "Please enter your mobile number");
                 number.focus();
                 return false;
             }

                var val = number.value
                if (/^\d{10}$/.test(val)) {
                    // value is ok, use it
                    return true
                } else {
                    alertModal("Opps! Problem with the Mobile Number", "Please make sure the mobile number has 10 digits.");
                    //alert("Invalid number; must be 10 digits!")
                    number.focus()
                    return false
                }
         }

         function ValidateEmail(input) {

             if (input.value == "") {
                 alertModal("Opps! Problem with the Email Id", "Please enter your Email Id");
                 input.focus();
                 return false;
             }

            var validRegex = /^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\.[a-zA-Z0-9-]+)*$/;

            if (input.value.match(validRegex)) {

                input.focus();
                return true;

            } else {

                alertModal("Opps! Problem with the Email Id", "Please enter your valid Email Id");

                input.focus();

                return false;

            }

        }


        
    </script>

    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <div class="row">
                    <div class="col-md-3">
                        <center>
                        <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:180px; height:80px; padding-top:10px">
                        </center>
                    </div>
                    <div class="col-md-6">
                        <h2 class="lblTopHeader">Verify mobile/email <i class="fas fa-envelope fa-lg me-3 fa-fw"></i></h2>
                        <p>Please take a moment to verify your <b>mobile number</b> and <b>email address</b>.</p>
                    </div>
                     <div class="col-md-3" style="display:flex;flex-direction:column;align-items:flex-end;">
                        <h5 id="hFullName" runat="server" style="margin:0px;"></h5>
                        <span>UCC: <span id="spanUCC" runat="server"></span></span>
                        <span>DOB: <span id="spanDOB" runat="server"></span></span>
                        <span>PAN: <span id="spanPan" runat="server"></span></span>
                        <span>Aadhaar: <span id="spanAadhaar" runat="server"></span></span>
                        <span id="spanMobile" runat="server"></span>
                        <span id="spanEmail" runat="server"></span>
                     </div>
                </div>
              <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5">
                    <div class="row justify-content-center">
                      <div class="col-md-10 col-lg-6">

                          <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                            <ContentTemplate>
                                <div style="display:none">
                                    <asp:Button ID="btnRequest" runat="server" Text="" OnClick="btnRequest_Click" /> 
                                    <input type="hidden" id="hdnBtnRequestClicked" name="hdnBtnRequestClicked" runat="server" value="">
                                </div>
                                <div class="d-flex flex-row align-items-center mb-4" id="divMobile"  runat="server"  style="display:none">
                                    <div class="form-outline flex-fill mb-0 margineTop10">
                                        <label class="form-label" for="txtMobile"><i class="fas fa-mobile fa-lg me-3 fa-fw"></i> Mobile</label>
                                        <input type="number"  class="form-control" id="txtMobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" readonly="readonly" placeholder="NA">
                                    </div>
                                </div>
                                <div class="d-flex flex-row align-items-center mb-4" id="divMobileNew"  runat="server">
                                    <div class="form-outline flex-fill mb-0 margineTop10">
                                      <label class="form-label" for="txtMobileNew"><i class="fas fa-mobile fa-lg me-3 fa-fw"></i> Mobile</label>
                                      <input type="number"  class="form-control" id="txtMobileNew" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Enter Mobile">
                                        <div style="margin-top:5px">
                                            <asp:DropDownList ID="cmbMobileDependancy" CssClass="form-control" runat="server"></asp:DropDownList>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex flex-row align-items-center mb-4">
                                    <div class="form-outline flex-fill mb-0 margineTop10"  id="divEmail"  runat="server" style="display:none">
                                        <label class="form-label" for="txtEmail"><i class="fas fa-envelope fa-lg me-3 fa-fw"></i> Email</label>
                                        <input type="email"  class="form-control" id="txtEmail" maxlength="300" runat="server" readonly="readonly" placeholder="NA">
                                    </div>
                                </div>
                                <div class="d-flex flex-row align-items-center mb-4" id="divEmailNew"  runat="server">
                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                  <label class="form-label" for="txtEmailNew"><i class="fas fa-envelope fa-lg me-3 fa-fw"></i> Email</label>
                                  <input type="email"  class="form-control" id="txtEmailNew" maxlength="300" runat="server" placeholder="Enter Email">
                                      <div style="margin-top:5px">
                                         <asp:DropDownList ID="cmbEmailDependancy" CssClass="form-control" runat="server"></asp:DropDownList>
                                      </div>
                                  </div>
                              </div>
                              <div id="divButton"  runat="server">
                                  <small id="smMsg" runat="server">You will receive separate OTPs on your mobile and email. These OTPs will be valid for only <b>10 minutes</b>. </small>
                                  <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4 margineTop10">
                                    <button type="button" class="btn btn-primary btn-lg" id="btnSendOTP" onclick="requestData('Sent OTP')" runat="server" ><i class="fa fa-share-square" aria-hidden="true"></i> Continue</button>
                                  </div>
                                </div>
                                <div id="divOTP"  runat="server"  style="display:none">
                                    <h5 style="color:green" id="msgOTPSentSuccessfully" runat="server">OTP has been sent successfully to your Mobile number and Email id.</h5>
                                    <div class="row justify-content-center">
                                    <div class="col-lg-6">
                                        <div class="form-outline flex-fill mb-0 margineTop10">
                                            <label class="form-label" for="txtMobileOTP"><i class="fas fa-mobile fa-lg me-3 fa-fw"></i> Mobile OTP</label>
                                            <input type="number" class="form-control" id="txtMobileOTP" maxlength="6" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Enter Mobile OTP">
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-outline flex-fill mb-0 margineTop10">
                                            <label class="form-label" for="txtEmailOTP"><i class="fas fa-envelope fa-lg me-3 fa-fw"></i> Email OTP</label>
                                            <input type="number" class="form-control" id="txtEmailOTP" maxlength="6" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Enter Email OTP">
                                                                        
                                        </div>
                                    </div>
                                    </div>
                                    <span id="spanDebugOTP" runat="server" style="display:none"></span>
                                </div>

                            </ContentTemplate>
                        </asp:UpdatePanel>
                           <div style="text-align:left; display:none" id="divConfirm" >
                               <button type="button" class="btn btn-lg btn-success margineTop10" id="btnOTPEmailValidate" onclick="requestData('Validate OTP')"><i class="fa fa-check" aria-hidden="true"></i> Verify and confirm OTP</button>
                               <button type="button" class="btn btn-lg btn-primary margineTop10" id="btnOTPEmailResend" onclick="requestData('Sent OTP')" style="display:none"><i class="fa fa-repeat" aria-hidden="true"></i> Resend OTP</button>
                               <div id="countdownTimer" style="display: none;">
                                    Please wait <span id="timer">30</span> seconds to resend OTP.
                               </div>
                               
                           </div>
                          <br />
                          <br />
                      </div>
                      <div class="col-md-10 col-lg-6 " style="text-align:center">
                          <img src="../ekyc/images/OTP.png" style="width:90%">
                      </div>
                    </div>
                    <hr />
                     <div id="divPreviousSteps" runat="server">
                        <h4>Go to previous step </h4> 
                        <ul class="list-inline">
                            <li><a href="ConfirmDetails.aspx?cnfmrset=1" id="hlinkChooseParameters" runat="server"><i class="fa fa-solid fa-list-check" aria-hidden="true"></i> Reset Modifications</a></li>
                            <li><a href="DigiLockerKYC.aspx" id="hlinkDigiLocker" runat="server"><i class="fa fa-cloud-download" aria-hidden="true"></i> DigiLocker</a></li>
                            <li><a href="manuallyProcessing.aspx" id="hlinkManuallyProcessing" runat="server"><i class="fa fa-id-card" aria-hidden="true"></i> <span id="spanManuallyProcessing" runat="server">Address|DOB</span> </a></li>
                            <li><a href="takePhoto.aspx" id="hlinkCapturePhoto" runat="server"><i class="fa fa-camera" aria-hidden="true"></i> Capture Photo</a></li>
                            <li><a href="incomeProfile.aspx" id="hlinkIncomeProfile" runat="server"><i class="fa fa-inr" aria-hidden="true"></i> Income Profile</a></li>
                            <li><a href="TradingPreference.aspx" id="hlinkTradingPreference" runat="server"><i class="fa fa-exchange" aria-hidden="true"></i> Trading Preference</a></li>
                            <li><a href="BankDetails.aspx" id="hlinkBankDetails" runat="server"><i class="fa fa-university" aria-hidden="true"></i> Bank</a></li>
                            <li><a href="Nomination.aspx" id="hlinkNomination" runat="server"><i class="fa fa-users" aria-hidden="true"></i> Nomination</a></li>
                            <li><a href="dematAccount.aspx" id="hlinkDematAccount" runat="server"><i class="fa fa-university" aria-hidden="true"></i> Demat Account</a></li>
                            <li><a href="AuthorizedRepresentative.aspx" id="hlinkAuthorizedRepresentative" runat="server"><i class="fa fa-user-circle" aria-hidden="true"></i> Authorized Representative</a></li>
                            <li><a href="uploadDocuments.aspx" id="hlinkUploadDocuments" runat="server"><i class="fa fa-upload" aria-hidden="true"></i> Upload documents</a></li>
                        </ul>
                     </div>
                  </div>
                </div>
              </div>
            </div>

              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6 poweredBy" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span></br>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
			    </div>
             </div>

          </div>
        </section>
        
    </form>

</body>
</html>
