﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="kraDocuments.aspx.cs" Inherits="Connect_DotNet.ReKYC.kraDocuments" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title>Upload KRA related documents</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
</head>
<body>
    <form id="form1" runat="server" enctype="multipart/form-data">
        <script>

            window.onload = function () {

                if (document.getElementById('hdnMsgModalOpen').value != "") {

                    const hdnMsgModalOpenArray = document.getElementById('hdnMsgModalOpen').value.split("####");
                    var titleMsg = hdnMsgModalOpenArray[0];
                    var Msg = hdnMsgModalOpenArray[1];

                    document.getElementById('hdnMsgModalOpen').value = "";
                    alertModal(titleMsg, Msg);

                }


            }

            function openTermsandConditions() {
            $('#modalTerms').modal('show');
            }

            function submitKRADocuments() {

                var isPhotoAvailable = false;
                var isAadhaarAvailable = false;
                var isPANAvailable = false;

                if (document.getElementById('hdnDigiLockerDocs').value != "") {

                    var strFileAvailable = document.getElementById('hdnDigiLockerDocs').value;

                    isPhotoAvailable = strFileAvailable.includes('Photo');
                    isAadhaarAvailable = strFileAvailable.includes('Aadhaar');
                    isPANAvailable = strFileAvailable.includes('PAN');
                }

                if (isPhotoAvailable == false) {
                    if (validateFileExtensionByElementId("filePhoto", "Recent passport size photo", "JPG,PNG,JPEG") == false) {
                        return;
                    }
                }

                if (validateFileExtensionByElementId("fileSignature", "Wet Signature image", "JPG,PNG,JPEG") == false) {
                    return;
                }

                if (isPANAvailable == false) {
                    if (validateFileExtensionByElementId("filePAN", "Copy of PAN card", "JPG,PNG,JPEG,PDF") == false) {
                        return;
                    }
                }

                if (isAadhaarAvailable == false) {
                    if (validateFileExtensionByElementId("fileAadhaar", "Copy of Aadhaar card", "JPG,PNG,JPEG,PDF") == false) {
                        return;
                    }
                }

                openTermsandConditions();

            }

            function validateFileExtensionByElementId(fileElementId, ElementType, fileTypes) {

                var fileElement = document.getElementById(fileElementId)
                var fileElementFileName = "";

                if (fileElement.value != "") {
                    fileElementFileName = fileElement.files.item(0).name.toUpperCase();
                }

                return validateFileExtensionByFileName(fileElementFileName, ElementType, fileTypes);

            }

            function validateFileExtensionByFileName(fileName, uploadType, fileTypes) {


                if (fileName == "") {
                    alertModal("Error : " + uploadType + " upload", "Please upload your " + uploadType + " in " + fileTypes + " format!");
                    return false;
                }

                const fileTypesArray = fileTypes.split(",");

                let matchesNameExtns = "";
                for (let i = 0; i < fileTypesArray.length; i++) {

                    if (i == fileTypesArray.length - 1) {
                        matchesNameExtns += "." + fileTypesArray[i] + "$";
                    }
                    else {
                        matchesNameExtns += "." + fileTypesArray[i] + "$|";
                    }

                }

                var fileElementFileName = fileName.toUpperCase();

                if (fileElementFileName.match(matchesNameExtns) == null) {
                    alertModal("Error : " + uploadType + " file upload", "Invalid file selected! Please select for upload " + uploadType + " file in " + fileTypes + " format!");
                    return false;
                }

                return true;

            }

            function alertModal(title, body) {
                // Display error message to the user in a modal
                $('#alert-modal-title').html(title);
                $('#alert-modal-body').html(body);

                if (title.match("Error") == "Error") {
                    $('#alert-modal-body').addClass("alert-danger");
                    $('#alert-modal-body').removeClass("alert-info");
                    $('#alert-modal-body').removeClass("alert-success");
                }

                else if (title == "Request added") {
                    $('#alert-modal-body').addClass("alert-success");
                    $('#alert-modal-body').removeClass("alert-info");
                    $('#alert-modal-body').removeClass("alert-danger");
                }
                else {
                    $('#alert-modal-body').addClass("alert-info");
                    $('#alert-modal-body').removeClass("alert-danger");
                    $('#alert-modal-body').removeClass("alert-success");
                }

                $('#alert-modal').modal('show');
            }


            function clickBtnSubmitRequest() {

                document.getElementById('btnIAgree').disabled = true;
                document.getElementById('divLoading').style = "display:block";
                document.getElementById('modalTermsLabel').innerHTML = "Request submission";
                document.getElementById('divtermsandconditionsHTML').style = "display:none";
                document.getElementById('btnIAgree').style = "display:none";
                document.getElementById('<%= btnSubmitRequest.UniqueID %>').click();

            }

        </script>

        <div class="container" id="divMain">
            <h2><i class="fa fa-user" aria-hidden="true"></i> Please upload KRA related documents for reKYC [#<%=requestId%>]</h2>
            <p>&nbsp;* You need to upload KRA related documents for this reKYC request –  The following information need to be submitted.</p>
            <p>&nbsp;* Please note that if you ignore this process then your Re-KYC request will be rejected.</p>
            
            <div class="row">
                <div class="col-md-8">
                    <div class="row" style="padding-top:20px">
                        <div class="col-sm-12">
					        <div class="form-group">
						        <label for="txtName" class="control-label col-sm-2">Name:</label>
						        <div class="col-sm-8" style="margin-left:-5px">
							        <input type="text"  class="form-control" id="txtName" runat="server" readonly="readonly">
						        </div>
					        </div>
                        </div>
                    </div>
                    <div class="row" style="padding-top:20px">
                        <div class="col-sm-12">
                            <div class="form-group">
                                <label for="fileSignature" class="control-label col-sm-4">Wet Signature image*:</label>
                                <div class="col-sm-8">
                                    <input type="file" class="form-control-file border" id="fileSignature" name="fileSignature" accept='.jpg,.png,.jpeg'>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row" style="padding-top:20px">
                        <div class="col-sm-12">
                            <div id="divPANcard" runat="server">
                                <div class="form-group">
                                    <label for="filePAN" class="control-label col-sm-4">Copy of PAN card*:</label>
                                    <div class="col-sm-8">
                                        <input type="file" class="form-control-file border" id="filePAN" name="filePAN" accept='.jpg,.png,.jpeg,.pdf'>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row" style="padding-top:20px">
                        <div class="col-sm-12">
                            <div id="divPhoto" runat="server">
                                <div class="form-group">
                                    <label for="filePhoto" class="control-label col-sm-4">Recent passport size photo*:</label>
                                    <div class="col-sm-8">
                                        <input type="file" class="form-control-file border" name="filePhoto" id="filePhoto" accept='.jpg,.png,.jpeg'>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row" style="padding-top:20px">
                        <div class="col-sm-12">
                            <div id="divAadhaar" runat="server">
                                <div class="form-group">
                                    <label for="fileAadhaar" class="control-label col-sm-4">Copy of Aadhaar (Both side)*:</label>
                                    <div class="col-sm-8">
                                        <input type="file" class="form-control-file border" id="fileAadhaar" name="fileAadhaar" accept='.jpg,.png,.jpeg,.pdf'>
                                        <span style="color:red; font-size:11px">
                                            Upload a single PDF or Image with both sides of the Aadhaar card. Before uploading Aadhaar, first 8 digits of Aadhaar Number should be blocked/blackened. Uploading non-masked Aadhaar will lead to rejection of the request.
                                        </span> 
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <i>&nbsp;* Uploaded files size should be less than 500 KB.</i><br />
                    <i>&nbsp;* Please ensure that you submit your documents in an acceptable format and that your documents are not password protected.</i><br />
                    <i>&nbsp;* Please don't upload corrupted files, this may be rejected your reKYC request.</i>
                    <div class="row">
                        <div class="col-sm-2">
                        </div>
                        <div class="col-sm-4 col-md-6">
                            <div style="text-align:center; padding-top:10px;">
                                <button type="button" class="btn btn-success btn-lg" style="margin-bottom:20px" onclick="submitKRADocuments();"><i class="fa fa-cloud-download" aria-hidden="true"></i> Submit KRA Documents</button>
                            </div>
                        </div>
                    </div>
            </div>
                <div class="col-md-4">
                        <div class="row">
                            <div class="col-xs-6">
                                <center>
                                <img id="ImgAadhaar" width="160" height="200" src="" alt="Aadhaar Photo" runat="server">
                                <br />
                                <span>Fetch from Aadhaar</span>
                                </center>
                            </div>
                            <div class="col-xs-6">
                                <center>
                                <img id="ImgLivePhotoCaptured" width="160" height="200" src="" alt="Aadhaar Photo" runat="server">
                                <br />
                                <span>Live photo captured</span>
                                </center>
                            </div>
                        </div>   
                    <br />

                    </div>
                </div>
        </div>

        <div class="modal fade" id="modalTerms" tabindex="-1" role="dialog" aria-labelledby="modalTermsLabel">
          <div class="modal-dialog modal-lg" style=" height: 97%;">
            <div class="modal-content" style=" height: 97%;">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h2 class="modal-title" id="modalTermsLabel">Terms and Conditions</h2>
              </div>
              <div class="modal-body" style="max-height: calc(75%);  overflow-y: scroll;">
                  <div id="divLoading" runat="server" style="display:none">
                    <center>
                        <h3>Please wait..Your request is being processed..</h3>
                        <p>Do not close browser window....</p>
                        <img src="Loading.gif" alt="Loading" style="width:150px;">
                    </center>
                 </div>
                  <div id="divtermsandconditionsHTML">
                      <%=termsandconditionsHTML%>
                  </div>

              </div>

              <div class="modal-footer">
                <button type="button" class="btn btn-success btn-lg" id="btnIAgree" onclick="clickBtnSubmitRequest();">I Agree and Submit</button>
              </div>
            </div>
          </div>
        </div>
        <div style="display:none">
            <input type="hidden" runat="server" id="hdnDigiLockerDocs" value="" name="hidden">
            <asp:Button ID="btnSubmitRequest" runat="server" Text="" OnClientClick="document.getElementById('divLoading').style = 'display:block';" OnClick="btnSubmitRequest_Click" />
            <input type="hidden" id="hdnMsgModalOpen" name="hdnMsgModalOpen" runat="server" value="">
        </div>
        <div id="alert-modal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 id="alert-modal-title" class="modal-title"></h4>
              </div>
              <div id="alert-modal-body" class="modal-body"></div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">OK</button>
              </div>
            </div>
          </div>
        </div>

    </form>
</body>
</html>
