﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="addBank.aspx.cs" Inherits="Connect_DotNet.eKYC.addBank" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<!DOCTYPE html>

<html>
<head runat="server">
  <title>Add a Bank account</title>
   <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <link href="css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />
    
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <script type="text/javascript" src="js/ekyc.js"></script>
    <!-- ssAjax : StanSoft Javascript Library 
        -->
    <script type="text/javascript" src="../../scripts/ssajax.js"></script>
      
</head>
<body>
     <style>
        .margineTop10{
            margin-top:10px
        }
    </style>
     <script>

         function togglePasswordAndValidate(targetId, currentInput) {
             var targetInput = document.getElementById(targetId);

             // Allow only numbers
             currentInput.value = currentInput.value.replace(/\D/g, '');

             currentInput.type = currentInput.value.length > 0 ? "text" : "password";

             // Hide the other field if input is not empty
             targetInput.type = currentInput.value.length > 0 ? "password" : "text";

             if (currentInput.value.length > currentInput.maxLength)
                 currentInput.value = currentInput.value.slice(0, currentInput.maxLength);
         }

         function disableCopyPaste(event) {
            event.preventDefault();
            alert("Copy-paste is disabled for this field.");
         }

         function CleanExistingFileData() {
             document.getElementById('spanBankVerificationFileUpload').innerHTML = "";
             document.getElementById('spanBankVerificationFileUpload').style.backgroundColor = "white";

             // Find the file upload control by its ID
             var asyncFileUpload = document.getElementById('<%= bankVerificationAsyncFile.ClientID %>');

             // Find the input of type 'file' inside the div
             const fileInput = asyncFileUpload.querySelector("input[type='file']");

             // Find the input of type 'hidden' inside the div
             const hiddenInput = asyncFileUpload.querySelector("input[type='hidden']");

             fileInput.value = ''; // Clear the input
             hiddenInput.value = '';
         }

         function findBank() {

             showModalLoading();

             if (document.getElementById('txtBankIFSC').value == "") {
                 alertModal("Error", "Please provide a valid IFSC Code! for Search your Bank!");
                 $('#modalLoading').modal('hide');
             }
   
         }

         function addBank() {

             //if (document.getElementById('cmbBanks') == null || document.getElementById('txtBankIFSC').value == "") {
             //    alertModal("Error", "Please provide a valid IFSC Code! for Search your Bank!");
             //    return;
             //}

             //if (document.getElementById('cmbBanks').value == "") {
             //    alertModal("Error", "IFSC Code not found in our database! Please provide a valid IFSC Code!");
             //    return;
             //}


             if (document.getElementById('txtBankIFSC').value == "") {
                 alertModal("Error", "Please provide a valid IFSC Code! for Search your Bank!");
                 return;
             }

             var foundIFSC = false;

             if (document.getElementById('cmbBanks') != null) {

                 if (document.getElementById('cmbBanks').value != "") {
                     foundIFSC = true;
                 }
             }

             if (foundIFSC != true) {

                 if (document.getElementById('txtBank').value == "") {
                     alertModal("Error", "Please enter your bank name!");
                     return;
                 }

                 if (document.getElementById('txtBankMICR').value == "") {
                     alertModal("Error", "Please enter your bank MICR!");
                     return;
                 }

             }

             if (document.getElementById('txtBankAccountNumber').value == "") {
                 alertModal("Error", "Please enter your bank account number!");
                 return;
             }

             if (document.getElementById('txtConfirmBankAccountNumber').value == "") {
                 alertModal("Error", "Please confirm bank account number!");
                 return;
             }

             if (document.getElementById('txtBankAccountNumber').value != document.getElementById('txtConfirmBankAccountNumber').value) {
                 alertModal("Error", "Entered Bank Account Numbers do not match");
                 return;
             }

             if (document.getElementById('hdnBankValidation').value != "API") {

                 if (document.getElementById('selectBankVerificationType').value == "") {
                     alertModal("Error", "Please select how to verification your bank a/c!");
                     return;
                 }

                 if (validateFileExtensionByFileName(document.getElementById('spanBankVerificationFileUpload').innerHTML, "Bank verification file (Canceled Cheque/Passbook 1st Page)", "JPG,PNG,JPEG") == false) {
                     return;
                 }

             }

             document.getElementById('hdnBtnContinueClicked').value = "Continue";

             showModalLoading();
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();

         }

         function successAsyncFileUpload(sender, args) {

             if ($(sender._element).find('input').attr('id').match("bankVerificationAsyncFile") == "bankVerificationAsyncFile") {

                 $(sender._element).find('input').css("background-color", "white");

                 var filename = $(sender._element).find('input').val().replace("C:\\fakepath\\", "");

                 document.getElementById('spanBankVerificationFileUpload').innerHTML = filename;
                 document.getElementById('spanBankVerificationFileUpload').style.backgroundColor = "lime";

             }
         }

         function validateFileExtensionByElementId(fileElementId, ElementType, fileTypes) {

             var fileElement = document.getElementById(fileElementId)
             var fileElementFileName = "";

             if (fileElement.value != "") {
                 fileElementFileName = fileElement.files.item(0).name.toUpperCase();
             }

             return validateFileExtensionByFileName(fileElementFileName, ElementType, fileTypes);

         }

         function validateFileExtensionByFileName(fileName, uploadType, fileTypes) {


             if (fileName == "") {
                 alertModal("Error : " + uploadType + " file upload", "Please select for upload " + uploadType + " file in " + fileTypes + " format!");
                 return false;
             }

             const fileTypesArray = fileTypes.split(",");

             let matchesNameExtns = "";
             for (let i = 0; i < fileTypesArray.length; i++) {

                 if (i == fileTypesArray.length - 1) {
                     matchesNameExtns += "." + fileTypesArray[i] + "$";
                 }
                 else {
                     matchesNameExtns += "." + fileTypesArray[i] + "$|";
                 }

             }

             var fileElementFileName = fileName.toUpperCase();

             if (fileElementFileName.match(matchesNameExtns) == null) {
                 alertModal("Error : " + uploadType + " file upload", "Invalid file selected! Please select for upload " + uploadType + " file in " + fileTypes + " format!");
                 return false;
             }

             return true;

         }

        
    </script>
    


    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <div class="row">
                <div class="col-md-3">
                    <center>
                    <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:180px; height:80px; padding-top:10px">
                    </center>
                </div>
                <div class="col-md-6">
                    <h2 class="lblTopHeader"><i class="fa fa-university" aria-hidden="true"></i> Your Bank Account Details</h2>
                    <p>Enter the details of your Bank Account that you want to link with Trading
                    </p>
                </div>
                <div class="col-md-3" style="display:flex;flex-direction:column;align-items:flex-end;">
                    <h4 id="hFullName" runat="server" style="margin:0px;"></h4>
                    <span>DOB: <span id="spanDOB" runat="server"></span></span>
                    <span id="spanMobile" runat="server"></span>
                    <span id="spanEmail" runat="server"></span>
                </div>
              </div>
              <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5">
                    <div class="row justify-content-center">
                      <div class="col-md-12">

                          <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                            <ContentTemplate>
                                <div style="display:none">
                                    <asp:Button ID="btnContinueClick" runat="server" Text="" OnClick="btnContinueClick_Click"/> 
                                    <input type="hidden" id="hdnBtnContinueClicked" name="hdnBtnContinueClicked" runat="server" value="">
                                </div>
                              <div class="d-flex flex-row align-items-center mb-4">
                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                      <div class="row">
                                          <div class="col-md-7">
                                              <div class="form-outline flex-fill mb-0">
                                                <label class="form-label" for="txtIFSC"><i class="fa fa-university" aria-hidden="true"></i> IFSC Code*</label>
                                                 <div>
                                                  <div class="row">
                                                      <div class="col-sm-8">
                                                            <input type="text" class="form-control" id="txtBankIFSC" runat="server" placeholder="Type IFSC">
                                                       </div>
                                                      <div class="col-sm-4">
                                                            <asp:Button ID="btnFindBank" CssClass="btn btn-info" OnClientClick="findBank();" runat="server" OnClick="btnFindBank_Click" Text="Find Bank" />
                                                        </div>
                                                  </div>
                                                 </div>
                                              </div>
                                              <div class="form-outline flex-fill mb-0" style="padding-top:10px">
                                                  <div id="divSelectBank" runat="server">
                                                      <label class="form-label" for="cmbBanks"><i class="fa  fa-university" aria-hidden="true"></i> Select Bank* </label>
                                                      <asp:DropDownList ID="cmbBanks" CssClass="form-control" runat="server">
                                                      </asp:DropDownList>
                                                  </div>
                                                <div id="divEnterBankDetails" runat="server" style="display:none">
                                                    <label class="form-label" for="cmbBanks"><i class="fa  fa-university" aria-hidden="true"></i> Bank Name and MICR* </label>
                                                    <div class="row">
                                                        <div class="col-sm-8">
                                                            <input type="text" class="form-control" id="txtBank" runat="server" placeholder="Enter Bank Name">
                                                        </div>
                                                        <div class="col-sm-4">
                                                            <input type="text" class="form-control" id="txtBankMICR" runat="server" placeholder="Enter MICR">
                                                        </div>
                                                    </div>
                                                </div>
                                              </div>
                                              <div class="form-outline flex-fill mb-0" style="padding-top:10px">
                                                  <label class="form-label" for="txtBankAccountNumber"><i class="fa fa-credit-card" aria-hidden="true"></i> Bank account number*</label>
                                                  <input type="number"  class="form-control" id="txtBankAccountNumber" maxlength="20" oninput="togglePasswordAndValidate('txtConfirmBankAccountNumber', this)" runat="server" placeholder="Enter Bank account number">
                                               </div>
                                               <div class="form-outline flex-fill mb-0">
                                                  <label class="form-label" for="txtConfirmBankAccountNumber"><i class="fa fa-credit-card" aria-hidden="true"></i> Confirm bank account number*</label>
                                                  <input type="password"   class="form-control" id="txtConfirmBankAccountNumber" maxlength="20" runat="server" placeholder="Confirm bank account number" 
                                                        onkeypress="CleanExistingFileData();"   
                                                        oncopy="disableCopyPaste(event)" 
                                                        onpaste="disableCopyPaste(event)" 
                                                        oncut="disableCopyPaste(event)" 
                                                        oninput="togglePasswordAndValidate('txtBankAccountNumber', this)">
                                               </div>
                                              <div id="divBankValidation" runat="server">
                                                  <input type="hidden" id="hdnBankValidation" name="hdnBankValidation" runat="server" value="">
                                                  <div class="form-outline flex-fill mb-0" style="padding-top:10px">
                                                      <label for="selectBankValidationType" class="form-label"><i class="fa fa-upload" aria-hidden="true"></i> Upload Document for account verification*:</label>
                                                      <div>
                                                          <div class="row">
                                                            <div class="col-sm-6">
                                                                <select class="form-control" id="selectBankVerificationType" runat="server">
                                                                    <option>Cancelled Cheque</option>
                                                                    <option>Passbook 1st Page</option>
                                                                </select>
                                                             </div>
                                                            <div class="col-sm-6" style="padding-left:30px; padding-top:10px">
                                                                <div class="form-group">
                                                                   <!-- <input type="file" class="form-control-file border" name="bankVerificationFile" id="bankVerificationFile" accept='.jpg,.png,.jpeg'>-->
                                                                    <ajaxToolkit:AsyncFileUpload ID="bankVerificationAsyncFile" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="bankVerificationAsyncFile_UploadedComplete" runat="server" />
                                                                    <span id="spanBankVerificationFileUpload" runat="server"></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                      </div>
                                                  </div>
                                                   <p style="position:relative;top:-15px;">
                                                       <span style="font-size:x-small;">
                                                        <i>Only upload files in JPG, PNG, JPEG, or PDF formats and the file should be under 2MB in size.</i>
                                                        </span>
                                                    </p>
                                              </div>


                                              <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4 margineTop10">
                                                  <button type="button" class="btn btn-success btn-lg" id="btnContinue" onclick="addBank();" runat="server" ><i class="fa fa-check" aria-hidden="true"></i> Save and Continue</button>

                                                  <p>
                                                      <div id="divTerms" runat="server" style="display:none">
                                                          <i>
                                                            * We are going to verify your Bank details using a Bank verification process. 
                                                              By clicking the above button, you agree that you have read the <a href="terms.aspx?type=bank" target="_blank">Terms & Conditions</a> for the Bank verification.
                                                          </i>
                                                      </div>
                                                      
                                                  </p>
                                                  <div id="divAlertMsg" runat="server" style="display:none" class="margineTop10" >
                                                  </div>
                                                  <br />
                                                  <br />
                                              </div>
                                          </div>
                                          <div class="col-md-5">
                                            <div>
                                                <img src="images/addbank.png"
                                                class="img-fluid" alt="Sample image" style="width:100%">
                                            </div>
                                           <div class="ekycCard">
                                               <h4 class="ekycCardTitle">Your Bank Detail is Important</h4>
                                               <div>
                                                   The bank details you enter here are crucial for operating your Trading
                                                   and Depository Account with us.
                                                   All payouts of funds will be sent to this Account, which will be treated as
                                                   your <i>Primary</i> Account. And also, all payments made by you should
                                                   be sent from <i>this account</i> only.
                                               </div>
                                            </div>
                                            
                                          </div>
                                      </div>
                                  </div>
                              </div>
                                <div style="padding-bottom:60px">
                                    <h4>Go to previous step </h4> 
                                        <ul class="list-inline">
                                        <li><a href="PANVerification.aspx"><i class="fa fa-id-card" aria-hidden="true"></i> PAN</a></li>
                                        <li><a href="selectSegments.aspx"><i class="fa fa-exchange" aria-hidden="true"></i> Segments</a></li>
                                        <li><a href="aadhaarKYC.aspx"><i class="fa fa-user" aria-hidden="true"></i> Aadhaar Data</a></li>
                                        <li><a href="capturePhoto.aspx"><i class="fa fa-camera" aria-hidden="true"></i> Capture Photo</a></li>
                                        <li><a href="profile.aspx"><i class="fa fa-user" aria-hidden="true"></i> Profile</a></li>
                                    </ul>
                                </div>
                            
                           </ContentTemplate>
                        </asp:UpdatePanel>

                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
              <!--<div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>-->


              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6 poweredBy" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span><br/>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
			    </div>
             </div>

          </div>
        </section>
    </form>
     
</body>
</html>
