﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="profile.aspx.cs" Inherits="Connect_DotNet.eKYC.profile" %>

<!DOCTYPE html>

<html>
<head>
  <title>Aadhaar KYC (DigiLocker)</title>
   <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>


  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
  <script type="text/javascript" src="js/ekyc.js"></script>

  <!--
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/js/bootstrap.bundle.min.js"></script>
  -->
  
    <!--<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
  <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.slim.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
      -->

    <link href="css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />

</head>
<body>
     <style>
        .margineTop10{
            margin-top:10px
        }

    </style>
     <script>

         function displayElement(actualValue, displayValue, element) {

             if (actualValue == displayValue) {
                 element.style.display = "block";
             } else {
                 element.style.display = "none";
             }
         }

         // Validations
         function saveData() {
             
             if (document.getElementById('txtFatherFirstName').value == "") {
                 alertModal("Error", "Please enter Father's First Name");
                 return;
             }

             if (document.getElementById('txtFatherLastName').value == "") {
                 alertModal("Error", "Please enter Father's Last Name");
                 return;
             }

             if (document.getElementById('txtMotherFirstName').value == "") {
                 alertModal("Error", "Please enter Mother's First Name");
                 return;
             }

             if (document.getElementById('txtMotherLastName').value == "") {
                 alertModal("Error", "Please enter Mother's Last Name");
                 return;
             }

             if (document.getElementById('txtAnnualIncome').value == "") {
                 alertModal("Error", "You have not entered your Annual Income");
                 return;
             }

             if (document.getElementById('txtAnnualIncome').value < 1) {
                 alertModal("Error", "Oops! Annual Income can't be 0 or negative!");
                 return;
             }

             if (document.getElementById('txtTradingExperience').value == "") {
                 document.getElementById('txtTradingExperience').value = 0;
             }

             if (document.getElementById('txtTradingExperience').value != "") {

                 if (document.getElementById('txtTradingExperience').value < 0) {
                     alertModal("Error", "Oops, Trading Experience cannot be negative");
                     return;
                 }

             }

             if (document.getElementById('selectOccupation').value == "") {
                 alertModal("Error", "Please select an Occupation");
                 return;
             }

             document.getElementById('hdnBtnContinueClicked').value = "Continue";
             
             showModalLoading();

             document.getElementById('<%= btnContinueClick.UniqueID %>').click();
             
         }


         // Client-side validation function
    function validateIntroducerType() {
        // Get selected value of DropDownList
        
        var selectedValue = document.getElementById('<%= cmbIntroducerType.ClientID %>').value;
        
        // Check if the value is empty or invalid
        if (selectedValue === "") {
            document.getElementById("divIntroducerCode").style.display = "none";
        } else {
            document.getElementById("divIntroducerCode").style.display = "block";
        }
    }
        
    </script>
    


    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <div class="row">
                <div class="col-md-3">
                    <center>
                    <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:180px; height:80px; padding-top:10px">
                    </center>
                </div>
                <div class="col-md-6">
                    <h2 class="lblTopHeader"><i class="fa fa-user" aria-hidden="true"></i> Additional Information</h2>
                    <p>Before we proceed, we need more information about you, your family, your Income, etc.</p>
                </div>
                <div class="col-md-3" style="display:flex;flex-direction:column;align-items:flex-end;">
                    <h4 id="hFullName" runat="server" style="margin:0px;"></h4>
                    <span>DOB: <span id="spanDOB" runat="server"></span></span>
                    <span id="spanMobile" runat="server"></span>
                    <span id="spanEmail" runat="server"></span>
                </div>
               </div>
              <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5">
                    <div class="row justify-content-center">
                      <div class="col-md-12">

                          <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                            <ContentTemplate>
                                <div style="display:none">
                                    <asp:Button ID="btnContinueClick" runat="server" Text="" OnClick="btnContinueClick_Click"/> 
                                    <input type="hidden" id="hdnBtnContinueClicked" name="hdnBtnContinueClicked" runat="server" value="">
                                </div>
                              <div class="d-flex flex-row align-items-center mb-4">
                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                      <div class="row">
                                          <div class="col-md-8">
                                              <div class="form-outline flex-fill mb-0">
                                                  <label class="form-label" for="rdblMaritalStatus"><i class="fa fa-users fa-lg" aria-hidden="true"></i> Marital status*: </label>
                                                  <asp:RadioButtonList ID="rdblMaritalStatus" RepeatLayout="Flow" RepeatDirection="Horizontal" runat="server">
                                                    <asp:ListItem class="radio-inline" Value="S" Text="Single" Selected="True"></asp:ListItem>
                                                    <asp:ListItem class="radio-inline" Value="M" Text="Married"></asp:ListItem>
                                                    <asp:ListItem class="radio-inline" Value="W" Text="Widowed"></asp:ListItem>
                                                    <asp:ListItem class="radio-inline" Value="D" Text="Divorced"></asp:ListItem>
                                                    <asp:ListItem class="radio-inline" Value="SE" Text="Separated"></asp:ListItem>
                                                   </asp:RadioButtonList>
                                              </div>
                                              <br />
                                              <div class="row">
                                                  <div class="col-sm-4">
                                                      <div class="form-outline flex-fill mb-0">
                                                        <label class="form-label" for="txtFatherFirstName"><i class="fa  fa-lg me-3 fa-male fa-fw" aria-hidden="true"></i> Father's First name*</label>
                                                        <input type="text"  class="form-control" id="txtFatherFirstName" onkeydown="return /[a-z ]/i.test(event.key)" runat="server" placeholder="Enter Father First name">
                                                      </div>
                                                  </div>
                                                  <div class="col-sm-4">
                                                      <div class="form-outline flex-fill mb-0">
                                                        <label class="form-label" for="txtFatherMiddleName">Father's Middle name</label>
                                                        <input type="text"  class="form-control" id="txtFatherMiddleName" onkeydown="return /[a-z ]/i.test(event.key)" runat="server" placeholder="Enter Father Middle name">
                                                      </div>
                                                  </div>
                                                  <div class="col-sm-4">
                                                      <div class="form-outline flex-fill mb-0">
                                                        <label class="form-label" for="txtFatherLastName">Father's Last name*</label>
                                                        <input type="text"  class="form-control" id="txtFatherLastName" onkeydown="return /[a-z ]/i.test(event.key)" runat="server" placeholder="Enter Father Last name">
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="row">
                                                  <div class="col-sm-4">
                                                      <div class="form-outline flex-fill mb-0 margineTop10">
                                                        <label class="form-label" for="txtMotherFirstName"><i class="fa fa-female fa-lg me-3 fa-fw"></i> Mother's First name*</label>
                                                        <input type="text"  class="form-control" id="txtMotherFirstName" runat="server" onkeydown="return /[a-z ]/i.test(event.key)" placeholder="Enter Mother First name">
                                                      </div>
                                                  </div>
                                                  <div class="col-sm-4">
                                                      <div class="form-outline flex-fill mb-0 margineTop10">
                                                        <label class="form-label" for="txtMotherMiddleName">Mother's Middle name</label>
                                                        <input type="text"  class="form-control" id="txtMotherMiddleName" onkeydown="return /[a-z ]/i.test(event.key)" runat="server" placeholder="Enter Mother Middle name">
                                                      </div>
                                                  </div>
                                                  <div class="col-sm-4">
                                                      <div class="form-outline flex-fill mb-0 margineTop10">
                                                        <label class="form-label" for="txtMotherLastName">Mother's Last name*</label>
                                                        <input type="text"  class="form-control" id="txtMotherLastName" runat="server" onkeydown="return /[a-z ]/i.test(event.key)" placeholder="Enter Mother Last name">
                                                      </div>
                                                  </div>
                                              </div>
                                              <hr />
                                              <h3>Introducer</h3>
                                              <p>Who referred you to us? If it was a client, please enter her <b>UCC</b>, or if it was
                                                  an <b>RM</b>, or an <b>Associate</b>, please enter her <b>Code</b> as provided to you.
                                                  Leave blank if you have come here on your own.</p>
                                               <div class="row">
                                                <div class="col-md-6">
                                                    <div style="padding-top:5px" class="form-outline flex-fill mb-0">
                                                        <label class="form-label" for="cmbIntroducerType"><i class="fa-solid fa-handshake fa-lg"></i> Who introduced you?</label>
                                                        <asp:DropDownList ID="cmbIntroducerType" CssClass="form-control" onchange="validateIntroducerType()" runat="server"></asp:DropDownList>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div id="divIntroducerCode" runat="server"  class="form-outline flex-fill mb-0" style="padding-top:5px; display:none">
                                                        <label class="form-label" for="txtIntroducerCode"><i class="fa fa-tag fa-lg" aria-hidden="true"></i> Enter Introducer's Code</label>
                                                        <input type="text"  class="form-control" id="txtIntroducerCode" runat="server">
                                                    </div>
                                                </div>
                                              </div>
                                              <hr />
                                              <h3>Background</h3>
                                              <div class="row">
                                                  <div class="col-md-6">
                                                      <div class="form-outline flex-fill mb-0">
                                                          <label class="form-label" for="txtAnnualIncome"><i class="fa fa-inr fa-lg" aria-hidden="true"></i> Annual Income*</label>
                                                          <input type="number"  class="form-control" id="txtAnnualIncome" maxlength="30" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Enter Annual Income in Rs.">
                                                       </div>
                                                  </div>
                                                  <div class="col-md-6">
                                                      <div class="form-outline flex-fill mb-0">
                                                        <label class="form-label" for="selectOccupation"><i class="fa fa-briefcase fa-lg me-3 fa-fw"></i> Occupation</label>
                                                          <select class="form-control" id="selectOccupation" runat="server">
                                                              <option>Service</option>
                                                              <option>Student</option>
                                                              <option>Housewife</option>
                                                              <option>Retired</option>
                                                              <option>Business</option>
                                                              <option>Professional</option>
                                                              <option>Agriculture</option>
                                                              <option>Landlord</option>
                                                              <option>Private Sector</option>
                                                              <option>Public Sector</option>
                                                              <option>Government Sector</option>
                                                              <option>Others</option>
                                                           </select>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="row">
                                                  <div class="col-md-6">
                                                      <div class="form-outline flex-fill mb-0 margineTop10">
                                                          <label class="form-label" for="txtTradingExperience"><i class="fa fa-calendar" aria-hidden="true"></i> Trading Experience (in years)</label>
                                                          <input type="number"  class="form-control" id="txtTradingExperience" maxlength="2" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Enter Trading Experience in Years.">
                                                       </div>
                                                  </div>
                                              </div>
                                              <div style="display:none">
                                                  <div class="form-check form-switch">
                                                      <label class="form-check-label" for="checkTaxResidentOtherThanIndia">Are you a tax resident of any country other than India?</label>
                                                      <input class="form-check-input" type="checkbox" id="checkTaxResidentOtherThanIndia" runat="server" name="darkmode" value="no">
                                                  </div>
                                                  <br />
                                                  <div class="form-check form-switch">
                                                      <label class="form-check-label" for="checkPoliticallyExposed">Are you politically exposed?</label>
                                                      <input class="form-check-input" type="checkbox" id="checkPoliticallyExposed" runat="server" name="darkmode" value="no">
                                                  </div>
                                              </div>
                                              <hr />

                                              <h3>Other Preferences</h3>
                                              <!-- Rev 15-03-2025 [Abs/Debasis/Mithun] 
                                                  The question has no meaning because the backoffice does not have this provision
                                                  -->
                                              <div class="row">
                                                <div class="col-md-8">
                                                    <h5>Frequency for receiving <i>Account Statement</i></h5>
                                                </div>
                                                <div class="col-md-4">
                                                    <select class="form-control" disabled="disabled" style="width:90%" id="selectAccountStatementRequirement" runat="server">
                                                        <option>As per SEBI Regulation</option>  
                                                        <option>Daily</option>  
                                                        <option>Weekly</option>
                                                        <option>Fortnightly</option>
                                                        <option>Monthly</option>
                                                    </select>
                                                </div>
                                            </div>
                                              <div class="row">
                                                <div class="col-md-8">
                                                    <h5>I would like to receive the <i>Annual Report</i></h5>
                                                </div>
                                                <div class="col-md-4">
                                                    <select class="form-control"  disabled="disabled" style="width:90%" id="selectReceiveAnnualReport" runat="server">
                                                        <option>Electronically</option>
                                                        <option>Physically</option>
                                                        <option>Both Physical and Electronic</option>
                                                    </select>
                                                </div>
                                             </div>
                                              <hr style="margin-top: 5px; margin-bottom: 5px;" />
                                              <div class="row">
                                                <div class="col-md-8">
                                                    <h5>Details of any action/proceedings initiated/pending/taken by 
                                                           SEBI/Stock Exchange/any other authority against you or 
                                                           your partners/promoters/whole time directors/authorized persons in charge 
                                                           of dealing in securities during the last 3 years</h5>
                                                    <div id="divActionTakenBySEBIExplain" runat="server"  style="display:none">
                                                        <label class="form-label" for="txtActionTakenBySEBIExplain">Please explain:</label>
                                                        <textarea class="form-control" rows="2" id="txtActionTakenBySEBIExplain" runat="server" placeholder="Please Explain"></textarea>
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <select class="form-control" style="width:90%" id="selectActionTakenBySEBI" onchange="displayElement(this.value,'Yes', document.getElementById('divActionTakenBySEBIExplain'))" runat="server">
                                                        <option>No</option>
                                                        <option>Yes</option>
                                                    </select>
                                                </div>
                                             </div>
                                              <hr style="margin-top: 5px; margin-bottom: 5px;" />
                                              <div class="row">
                                                <div class="col-md-8">
                                                    <%--<h5>INFORMATION PROVIDED BY THE CLIENT IN RELATION TO THE PREVENTION OF MONEY LAUNDERING ACT, 2002 Details of my Relatives, having account with  <span id="spanBroker" style="font-weight:bold" runat="server"></span></h5>--%>
                                                    Does any of your relatives have an account with <span id="spanBroker" style="font-weight:bold" runat="server"></span>
                                                    <div id="divRelativeHavingAccount" runat="server"  style="display:none">
                                                        <div class="row">
                                                          <div class="col-sm-12">
                                                              <div class="form-outline flex-fill mb-0">
                                                                <label class="form-label" for="txtRelativeAccountName">Relative's Name</label>
                                                                <input type="text"  class="form-control" id="txtRelativeAccountName" onkeydown="return /[a-z ]/i.test(event.key)" runat="server" placeholder="Name">
                                                              </div>
                                                          </div>
                                                        </div>
                                                        <div class="row">
                                                          <div class="col-sm-6">
                                                              <div class="form-outline flex-fill mb-0">
                                                                <label class="form-label" for="txtRelativeRelationship">Relationship with you</label>
                                                                <input type="text"  class="form-control" id="txtRelativeRelationship" onkeydown="return /[a-z ]/i.test(event.key)" runat="server" placeholder="Relationship">
                                                              </div>
                                                          </div>
                                                          <div class="col-sm-6">
                                                              <div class="form-outline flex-fill mb-0">
                                                                <label class="form-label" for="txtRelativeUCC">UCC</label>
                                                                <input type="text"  class="form-control" id="txtRelativeUCC"  runat="server" placeholder="UCC">
                                                              </div>
                                                          </div>
                                                      </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <select class="form-control" style="width:90%" id="selectRelativeHavingAccount" onchange="displayElement(this.value,'Yes', document.getElementById('divRelativeHavingAccount'))" runat="server">
                                                        <option>No</option>
                                                        <option>Yes</option>
                                                    </select>
                                                </div>
                                             </div>
                                              <hr />
                                               <div class="row">
                                                <div class="col-md-8">
                                                    <h5>I intend to invest in the stock market with</h5>
                                                    <div id="divInvestFromBorrowedFunds" runat="server"  style="display:none">
                                                        <div class="row">
                                                          <div class="col-sm-6">
                                                              <div class="form-outline flex-fill mb-0">
                                                                <label class="form-label" for="txtInvestFromBorrowedFundsSources">Sources of Borrowed Funds</label>
                                                                <input type="text"  class="form-control" id="txtInvestFromBorrowedFundsSources" onkeydown="return /[a-z ]/i.test(event.key)" runat="server" placeholder="Sources of Borrowed Funds">
                                                              </div>
                                                          </div>
                                                          <div class="col-sm-6">
                                                              <div class="form-outline flex-fill mb-0">
                                                                <label class="form-label" for="txtInvestFromBorrowedFundsAmount">Amount</label>
                                                                <input type="number"  maxlength="30" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" class="form-control" id="txtInvestFromBorrowedFundsAmount" runat="server" placeholder="Amount">
                                                              </div>
                                                          </div>
                                                      </div>
                                                    </div>
                                                </div>

                                                <div class="col-md-4">
                                                    <select class="form-control" style="width:90%" id="selectInvestFundsFrom" onchange="displayElement(this.value,'Borrowed Funds', document.getElementById('divInvestFromBorrowedFunds'))" runat="server">
                                                        <option>My Own Funds</option>
                                                        <option>Borrowed Funds</option>
                                                    </select>
                                                </div>
                                             </div>

                                              <hr />
                                              <div class="row">
                                                <div class="col-md-8">
                                                    <h5 style="margin-top:5px;margin-bottom:0px">Settlements of Running Accounts</h5>
                                                    <span style="font-size:x-small">[As per SEBI regulations, we need to clear out your credits with us on a regular 
                                                    frequency of your choice. Please choose your preferred frequency]</span>
                                                </div>
                                                <div class="col-md-4">
                                                    <!-- <option>Regular/None</option>-->
                                                    <select class="form-control" style="width:90%" id="selectSettlementsRunningAccounts" runat="server">
                                                        <option>Quarterly</option>
                                                        <option>Monthly</option>
                                                    </select>
                                                </div>
                                             </div>
                                              <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4 margineTop10">
                                                  <button type="button" class="btn btn-success btn-lg" id="btnContinue" onclick="saveData();" runat="server" ><i class="fa fa-check" aria-hidden="true"></i> Continue</button>
                                  
                                                  <div id="divAlertMsg" runat="server" style="display:none" class="margineTop10" >
                                                  </div>
                                                  <br />
                                                  <br />
                                              </div>
                                          </div>
                                          <div class="col-md-4">
                                             <div class="row">
                                                  <div class="col-xs-6">
                                                      <center>
                                                      <img id="ImgAadhaar" width="160" height="200" src="" alt="Aadhaar Photo" runat="server">
                                                      <br />
                                                      <span>Fetch from Aadhaar</span>
                                                       </center>
                                                  </div>
                                                  <div class="col-xs-6">
                                                      <center>
                                                      <img id="ImgLivePhotoCaptured" width="160" height="200" src="" alt="Aadhaar Photo" runat="server">
                                                      <br />
                                                      <span>Live photo captured</span>
                                                       </center>
                                                  </div>
                                              </div>
                                          </div>
                                      </div>
                                       <h4>Go to previous step </h4> 
                                             <ul class="list-inline">
                                                <li><a href="PANVerification.aspx"><i class="fa fa-id-card" aria-hidden="true"></i> PAN</a></li>
                                                <li><a href="selectSegments.aspx"><i class="fa fa-exchange" aria-hidden="true"></i> Segments</a></li>
                                                <li><a href="aadhaarKYC.aspx"><i class="fa fa-user" aria-hidden="true"></i> Aadhaar Data</a></li>
                                                <li><a href="capturePhoto.aspx"><i class="fa fa-camera" aria-hidden="true"></i> Capture Photo</a></li>
                                            </ul>
                                  </div>
                              </div>
                              

                            </ContentTemplate>
                        </asp:UpdatePanel>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
              <!--<div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>-->


              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6 poweredBy" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span><br/>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
                      <br />
                      <br />
			    </div>
                
             </div>

          </div>
        </section>
    </form>
     
</body>
</html>
